/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef CONFIGFILE_H_
#define CONFIGFILE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ConfIO.h"
#include <string>
#include <iosfwd>
#include <list>

class Config;
class ConfErrorHandler;

class ConfigFile
{
public:
	void clear();
	
	void load(std::string const& text,
		Config& target, ConfErrorHandler& eh);
	
	void updateWith(Config const& config);
	
	void swap(ConfigFile& other);
	
	void toStream(std::ostream& strm) const;
private:
	class Reader;
	class Updater;
	
	std::list<ConfIO::Element> m_elements;
};


inline void swap(ConfigFile& o1, ConfigFile& o2)
{
	o1.swap(o2);
}

inline std::ostream& operator<<(std::ostream& strm, ConfigFile const& file)
{
	file.toStream(strm);
	return strm;
}

#endif
