/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HTTPMESSAGEMETADATA_H_
#define HTTPMESSAGEMETADATA_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "types.h"

class HttpMessageMetadata
{
public:
	enum BodyStatus {
		BODY_SIZE_KNOWN,
		BODY_SIZE_UNKNOWN,
		BODY_FORBIDDEN
	};
	
	HttpMessageMetadata()
	: m_bodyStatus(BODY_SIZE_UNKNOWN), m_bodySize(0), m_clientRequestId(0) {}
	
	BodyStatus getBodyStatus() const { return m_bodyStatus; }
	
	void setBodyStatus(BodyStatus status) { m_bodyStatus = status; }
	
	uintmax_t getBodySize() const { return m_bodySize; }
	
	void setBodySize(uintmax_t size) { m_bodySize = size; }
	
	bool hasBody() const {
		return (m_bodyStatus == BODY_SIZE_UNKNOWN ||
			(m_bodyStatus == BODY_SIZE_KNOWN && m_bodySize != 0));
	}
	
	int getClientRequestId() const { return m_clientRequestId; }
	
	void setClientRequestId(int id) { m_clientRequestId = id; }
protected:
	~HttpMessageMetadata() {}
private:
	BodyStatus m_bodyStatus;
	uintmax_t m_bodySize;
	int m_clientRequestId; // used for debug purposes
};

#endif
