/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ABSTRACTCOMPRESSOR_H_
#define ABSTRACTCOMPRESSOR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stddef.h>
#include <limits>

class SplittableBuffer;

class AbstractCompressor
{
public:
	virtual ~AbstractCompressor() {}
	
	virtual void reset() = 0;
	
	virtual bool isError() const = 0;
	
	// postcondition: data is empty
	virtual void consume(SplittableBuffer& data, bool eof) = 0;
	
	// returns the number of bytes written
	// may cause isError() to become true
	virtual size_t retrieveOutput(SplittableBuffer& buf,
		size_t limit = std::numeric_limits<size_t>::max()) = 0;
};

#endif
