/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <SystemConfiguration/SystemConfiguration.h>
#include <CoreFoundation/CoreFoundation.h>
#include "LocationUpdater.h"
#include <exception>
#include <cstdio>
#include <unistd.h>

using namespace std;

int main (int argc, const char * argv[]) {
	try {
		LocationUpdater prefs;
		for (int i = 0; i < 2; ++i) {
			if (prefs.tryLock() || SCError() != kSCStatusPrefsBusy) {
				break;
			}
			sleep(1);
		}
		if (!prefs.isLocked()) {
			CFShow(CFSTR("Unable to lock the preferences"));
			return 1;
		}
		
		prefs.updateLocations();
		if (!prefs.applyChanges()) {
			CFShow(CFSTR("Could not apply changes"));
			return 1;
		}
	} catch (std::exception& e) {
		printf("Error: %s\n", e.what());
		return 1;
	}
    return 0;
}
