/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef MVCLISTMODEL_H_
#define MVCLISTMODEL_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include "IntrusiveList.h"

class MvcListView;
class wxString;
class wxListItemAttr;

class MvcListModel
{
	DECLARE_NON_COPYABLE(MvcListModel)
	friend class MvcListView;
public:
	MvcListModel();

	virtual ~MvcListModel();
private: /* to be used by MvcListView */
	void attachView(MvcListView& view);

	virtual long getRowCount() const = 0;

	virtual wxString getCellText(long row, long col) const = 0;

	virtual int getRowImage(long row) const = 0;

	virtual wxListItemAttr* getRowAttr(long row) const = 0;
protected:
	void informRowsInserted(long idx_begin, long idx_end);
	
	void informRowInserted(long row) { informRowsInserted(row, row+1); }

	void informRowsDeleted(long idx_begin, long idx_end);

	void informRowDeleted(long row) { informRowsDeleted(row, row+1); }

	void informRowsModified(long idx_begin, long idx_end);

	void informRowModified(long row) { informRowsModified(row, row+1); }
private:
	typedef IntrusiveList<MvcListView> Views;
	
	void invalidateRows(MvcListView& view, long idx_begin, long idx_end);
	
	void invalidateRows(MvcListView& view, long idx_begin);

	Views m_views;
};

#endif
