/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HtmlNode.h"
#include <cassert>

using namespace std;

HtmlNode::HtmlNode()
:	m_pParent(0),
	m_pPrev(this),
	m_pNext(this)
{
}

HtmlNode::~HtmlNode()
{
	m_pPrev->m_pNext = m_pNext;
	m_pNext->m_pPrev = m_pPrev;
}

void
HtmlNode::insertChildAfter(HtmlNode* new_child, HtmlNode* prev_child)
{
	assert(!new_child->m_pParent);
	assert(prev_child->m_pParent == this || !prev_child->m_pParent);
	// prev_child->m_pParent is null when prev_child is a sentinel node.
	
	new_child->ref();
	new_child->m_pParent = this;
	new_child->m_pPrev = prev_child;
	new_child->m_pNext = prev_child->m_pNext;
	prev_child->m_pNext->m_pPrev = new_child;
	prev_child->m_pNext = new_child;
}

void
HtmlNode::insertChildBefore(HtmlNode* new_child, HtmlNode* next_child)
{
	assert(!new_child->m_pParent);
	assert(next_child->m_pParent == this || !next_child->m_pParent);
	// next_child->m_pParent is null when prev_child is a sentinel node.
	
	new_child->ref();
	new_child->m_pParent = this;
	new_child->m_pNext = next_child;
	new_child->m_pPrev = next_child->m_pPrev;
	next_child->m_pPrev->m_pNext = new_child;
	next_child->m_pPrev = new_child;
}

void
HtmlNode::detachFromParent()
{
	assert(m_pParent);
	
	m_pPrev->m_pNext = m_pNext;
	m_pNext->m_pPrev = m_pPrev;
	if (unref()) {
		m_pPrev = m_pNext = this;
		m_pParent = 0;
	} // otherwise this object is already destroyed
}
