;;
; KAE 2003/06/28 19:00 
; Generator of environment variable settings from inside bergman
; used in environ.lsp (BANNER)
(let ((filename "environ0.lsp"))
  (with-open-file (outf filename :direction :output :if-exists :append)
   (write-line "" outf)
   (write-line ";;" outf)
   (write-line " (defun ENVVARSSET ()" outf)
   (write-line (CONCATENATE 'STRING "  (SETF (EXT:GETENV \"bmroot\") \"" (SUBSTITUTE #\/ #\\ (EXT:GETENV "bmroot")) "\")") outf)
   (write-line (CONCATENATE 'STRING "  (SETF (EXT:GETENV \"bmsrc\") \""  (SUBSTITUTE #\/ #\\ (EXT:GETENV "bmsrc")) "\")") outf)
   (write-line (CONCATENATE 'STRING "  (SETF (EXT:GETENV \"bmdomains\") \"" (SUBSTITUTE #\/ #\\ (EXT:GETENV "bmdomains")) "\")") outf)
   (write-line (CONCATENATE 'STRING "  (SETF (EXT:GETENV \"bmaux\") \""     (SUBSTITUTE #\/ #\\ (EXT:GETENV "bmaux")) "\")") outf)
   (write-line (CONCATENATE 'STRING "  (SETF (EXT:GETENV \"bmauxil\") \""   (SUBSTITUTE #\/ #\\ (EXT:GETENV "bmauxil")) "\")") outf)
   (write-line (CONCATENATE 'STRING "  (SETF (EXT:GETENV \"bmload\") \""    (SUBSTITUTE #\/ #\\ (EXT:GETENV "bmload")) "\")") outf)
   (write-line (CONCATENATE 'STRING "  (SETF (EXT:GETENV \"bmexe\") \""     (SUBSTITUTE #\/ #\\ (EXT:GETENV "bmexe")) "\")") outf)
   (write-line (CONCATENATE 'STRING "  (SETF (EXT:GETENV \"bmvers\") \""    (SUBSTITUTE #\/ #\\ (EXT:GETENV "bmvers")) "\")") outf)
   (write-line " )" outf)
   NIL
  )
)
(EXIT-ON-ERROR
 (COMPILE-FILE "environ0.lsp")
)
(LOAD "environ0.fas")
(IN-PACKAGE "ENVIRON0")
(COMPILE-FILE "environ.lsp")
(LOAD "environ.fas")
(SETQ *COMPILE-WARNINGS* NIL)
(IN-PACKAGE "Bergman")
(C-OFF RAISE)
(LOAD "versmacr.sl")
(C-OFF RAISE)
(LOAD "specmode.sl")
(C-OFF RAISE)
(LOAD "specmacr.sl")
(C-OFF RAISE)
(COND ((PROBE-FILE "speccmp1.sl")
	       (LOAD "speccmp1.sl")))
(QUIT)

