// TLVBuffer.cpp: implementation of the CTLVBuffer class.
//
//////////////////////////////////////////////////////////////////////

#include "TLVBuffer.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

char CTLVBuffer::hexChars[] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

CTLVBuffer::CTLVBuffer()
{

}

CTLVBuffer::~CTLVBuffer()
{
    ITMap it;
    for (it = m_oMapTLV.begin(); it != m_oMapTLV.end(); ++it)
    {
        CTLV *pTemp = (*it).second;
        if(pTemp != NULL)
        {
            delete pTemp;
        }
    }
    m_oMapTLV.clear();
}

int CTLVBuffer::ParseTLV(unsigned char *pucData, unsigned long ulLen)
{
    int iRet = 0;
    
    if(pucData != NULL && ulLen > 0)
    {
        m_oMapTLV.clear();

        unsigned long ulIndex = 0;
        while (ulIndex < ulLen)
        {
            unsigned char ucTag = pucData[ulIndex++];
            unsigned long ulFieldLen = pucData[ulIndex];
            
            if(ucTag == 0x00 && ulIndex > 2)
            {
                break;
            }
            while(0xFF == pucData[ulIndex])
            {
                ulFieldLen += pucData[++ulIndex];
            }
            ++ulIndex;
            m_oMapTLV[ucTag] = new CTLV(ucTag, pucData + ulIndex, ulFieldLen);
            ulIndex += ulFieldLen;
        }
        iRet = 1;
    }
    return iRet;
}

CTLV *CTLVBuffer::GetTagData(unsigned char ucTag)
{
    ITMap it = m_oMapTLV.find(ucTag);
    if(it != m_oMapTLV.end())
    {
        return(*it).second;
    }
    return NULL;
}

void CTLVBuffer::FillASCIIData(unsigned char ucTag, char *pData)
{
    CTLV *pTagData = NULL;
    if(NULL != (pTagData = GetTagData(ucTag)))
    {
        memcpy(pData, pTagData->GetData(), pTagData->GetLength());
    }
}

void CTLVBuffer::FillUTF8Data(unsigned char ucTag, char *pData)
{
    CTLV *pTagData = NULL;
    if(NULL != (pTagData = GetTagData(ucTag)))
    {
        memcpy(pData, pTagData->GetData(), pTagData->GetLength());
    }
}

void CTLVBuffer::FillBinaryStringData(unsigned char ucTag, char *pData)
{
    CTLV *pTagData = NULL;
    if(NULL != (pTagData = GetTagData(ucTag)))
    {
        char *pszTemp = Hexify(pTagData->GetData(), pTagData->GetLength());
        memcpy(pData, pszTemp, strlen(pszTemp));
        delete pszTemp;
    }
}

void CTLVBuffer::FillIntData(unsigned char ucTag, int *piData)
{
    CTLV *pTagData = NULL;
    if(NULL != (pTagData = GetTagData(ucTag)))
    {
        char *pszTemp = new char[pTagData->GetLength() + 1];
        memset(pszTemp, 0, pTagData->GetLength() + 1);
        memcpy(pszTemp, pTagData->GetData(), pTagData->GetLength());
        *piData = atoi(pszTemp);
        delete []pszTemp;
    }
}

void CTLVBuffer::FillLongData(unsigned char ucTag, long *piData)
{
    CTLV *pTagData = NULL;
    if(NULL != (pTagData = GetTagData(ucTag)))
    {
        char *pszTemp = new char[pTagData->GetLength() + 1];
        memset(pszTemp, 0, pTagData->GetLength() + 1);
        memcpy(pszTemp, pTagData->GetData(), pTagData->GetLength());
        *piData = atol(pszTemp);
        delete []pszTemp;
    }
}

void CTLVBuffer::FillBinaryData(unsigned char ucTag, unsigned char *pData, unsigned long *ulLength)
{
    CTLV *pTagData = NULL;
    if(NULL != (pTagData = GetTagData(ucTag)))
    {
        memcpy(pData, pTagData->GetData(), pTagData->GetLength());
        *ulLength = pTagData->GetLength();
    }
}

char *CTLVBuffer::Hexify(unsigned char * pData, unsigned long ulLen) 
{
    char *pszHex = new char[ulLen*2 + 1];
    memset(pszHex, 0, ulLen*2 + 1);
    if(pData != NULL)
    {
        int j = 0;
        for(unsigned long i = 0; i < ulLen; i++) 
        {
            pszHex[j++] = hexChars[pData[i]>>4 & 0x0F];
            pszHex[j++] = hexChars[pData[i] & 0x0F];
         }
    }
    return pszHex;
}

int CTLVBuffer::BytesToInt(unsigned char * pData, unsigned long ulLen) 
{ 
    int iOut = 0; 
    for (unsigned int i = 0; i < ulLen; i++) 
    { 
        iOut = iOut << 4; 
        iOut = iOut | ((pData[i] >> 4) & 0x0F); 
        iOut = iOut << 4; 
        iOut = iOut | (pData[i] & 0x0F); 
    }
    return iOut; 
}  

