/*
 * pkcs11 low level testing
 *
 * Copyright (C) 2002  Zetes
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "pkcs11-lowlevel.h"

int c_Logout()
{
	int errors = 0;
	CK_SESSION_HANDLE session;
	CK_RV rv;

	printf("C_LogOut\n");

	if (p11->C_Initialize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Initialize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}
	session = getSessionInFirstSlot();

	/* test 1 */
	if (p11->C_Logout(12345) != CKR_SESSION_HANDLE_INVALID) {
		printf("    ERR: C_Logout(1) didn't return CKR_SESSION_HANDLE_INVALID\n");
		errors++;
	}

	/* test 2 */
	if (p11->C_Login(session, CKU_USER, "1234", 4) != CKR_OK) { /* fixme */
		printf("    ERR: C_Login didn't return CKR_OK\n");
		errors++;
	}
	if (p11->C_Logout(session) != CKR_OK) {
		printf("    ERR: C_Logout(2) didn't return CKR_OK\n");
		errors++;
	}

	/* test 3 */
	if (p11->C_Logout(session) != CKR_USER_NOT_LOGGED_IN) {
		printf("    ERR: C_Logout(3) didn't return CKR_USER_NOT_LOGGED_IN\n");
		errors++;
	}

	/* test4 */
	if (p11->C_Finalize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Finalize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}
	if (p11->C_Logout(12345) != CKR_CRYPTOKI_NOT_INITIALIZED) {
		printf("    ERR: C_Logout(4) didn't return CKR_CRYPTOKI_NOT_INITIALIZED\n");
		errors++;
	}

	return errors;
}
