/*
 * pkcs11 low level testing
 *
 * Copyright (C) 2002  Zetes
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "pkcs11-lowlevel.h"

int c_Login()
{
	char *pin = "1234";
	CK_ULONG pinLen = (pin == NULL_PTR ? 0 : strlen(pin));

	int errors = 0;
	CK_SESSION_HANDLE session;
	CK_SESSION_INFO info;
	CK_RV rv;
	CK_BBOOL isPAP;

	if (p11->C_Initialize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Initialize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}

	isPAP = slotWithTokenIsPAP();
	if (isPAP) {
		pin = NULL_PTR;
		pinLen = 0;
	}

	printf("C_Login %s\n", isPAP ? "with pin pad reader" : "with pin = 1234");

	printf("  Cat 1\n");

	/* test 1 */
	if (p11->C_Login(12345, CKU_USER, pin, pinLen) != CKR_SESSION_HANDLE_INVALID) {
		printf("    ERR: C_Login(1) didn't return CKR_SESSION_HANDLE_INVALID\n");
		errors++;
	}

	/* test 2 */
	session = getSessionInFirstSlot();
	if (p11->C_GetSessionInfo(session, &info) != CKR_OK) {
		printf("    ERR: C_GetSessionInfo() didn't return CKR_OK\n");
		errors++;
	}
	if (info.state != CKS_RO_PUBLIC_SESSION) {
		printf("    ERR: session state not equal to CKS_RO_PUBLIC_SESSION\n");
		errors++;
	}

	if (isPAP)
		printf("    Enter a your PIN on the pin pad reader\n");
	rv = p11->C_Login(session, CKU_USER, pin, pinLen);
	if (rv  != CKR_OK) {
		printf("    ERR: C_Login(2) didn't return CKR_OK but %s\n", CKR2Str(rv));
		exit(++errors);
	}

	/* test 3 */
	rv = p11->C_Login(session, CKU_USER, pin, pinLen);
	if (rv != CKR_USER_ALREADY_LOGGED_IN) {
		printf("    ERR: C_Login(3) didn't return CKR_USER_ALREADY_LOGGED_IN but %s\n", CKR2Str(rv));
		exit(++errors);
	}

	printf("  Cat 2\n");

	if (p11->C_GetSessionInfo(session, &info) != CKR_OK) {
		printf("    ERR: C_GetSessionInfo(1) didn't return CKR_OK\n");
		errors++;
	}
	if (info.state != CKS_RO_USER_FUNCTIONS) {
		printf("    ERR: session state not equal to CKS_RO_USER_FUNCTIONS\n");
		errors++;
	}
	if ((rv = p11->C_Logout(session)) != CKR_OK) {
		printf("    ERR: C_Login(1) didn't return CKR_OK but %s\n", CKR2Str(rv));
		exit(++errors);
	}

	printf("  Cat 3\n");

	/* test 1 */
	if (isPAP)
		printf("    Enter a wrong PIN on the pin pad reader\n");
	if ((rv = p11->C_Login(session, CKU_USER, "84683904", 8)) != CKR_PIN_INCORRECT) {
		printf("    ERR: C_Login(1) didn't return CKR_PIN_INCORRECT but %s\n", CKR2Str(rv));
		exit(++errors);
	}

	/* test 2 */
	if (isPAP)
		printf("    Enter a too small or too large PIN on the pin pad reader\n");
	if ((rv = p11->C_Login(session, CKU_USER, "1", 1)) != CKR_ARGUMENTS_BAD) {
		printf("    ERR: C_Login(2) didn't return CKR_ARGUMENTS_BAD but %s\n", CKR2Str(rv));
		exit(++errors);
	}

	/* Reset PIN retry counter */
	if (isPAP)
		printf("    Enter the correct PIN on the pin pad reader\n");
	if ((rv = p11->C_Login(session, CKU_USER, pin, pinLen)) != CKR_OK) {
		printf("    ERR: C_Login(2) didn't return CKR_OK but %s\n", CKR2Str(rv));
		exit(++errors);
	}

	/* test 3 */
	if (p11->C_Finalize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Finalize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}
	if (p11->C_Login(session, CKU_USER, pin, pinLen) != CKR_CRYPTOKI_NOT_INITIALIZED) {
		printf("    ERR: C_CloseSession(3) didn't return CKR_CRYPTOKI_NOT_INITIALIZED\n");
		errors++;
	}

	return errors;
}


int c_Login_PP()
{
	int errors = 0;
	CK_SESSION_HANDLE session;
	CK_RV rv;
	CK_BBOOL isPAP;

	if (p11->C_Initialize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Initialize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}

	isPAP = slotWithTokenIsPAP();

	printf("C_Login with pin pad reader, Category 4 tests\n");

	if (!isPAP) {
		printf("  No pin pad reader present, can't do this test, exiting\n");
		exit(0);
	}

	session = getSessionInFirstSlot();

	rv = p11->C_Login(session, CKU_USER, NULL_PTR, 0);
	if (rv  != CKR_OK) {
		printf("    ERR: C_Login(1) didn't return CKR_OK but %s\n", CKR2Str(rv));
		exit(++errors);
	}
}
