/*
 * pkcs11 low level testing
 *
 * Copyright (C) 2002  Zetes
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "pkcs11-lowlevel.h"

int c_GetSlotList()
{
	int errors = 0;
	CK_SLOT_ID slotList[100];
	CK_ULONG numSlots, numSlots1;
	CK_ULONG MIN_SLOTS = 4;

	printf("C_GetSlotList\n");

	if (p11->C_Initialize(NULL_PTR) != CKR_OK) {
		printf("    C_Initialize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}

	if (p11->C_GetSlotList(FALSE, NULL_PTR, &numSlots) != CKR_OK) {
		printf("    C_GetSlotList(1) didn't return CKR_OK\n");
		return ++errors;
	}
	if (numSlots < MIN_SLOTS) {
		printf("    C_GetSlotList(1) returns less then %d slots\n", MIN_SLOTS);
		return errors;
	}

	numSlots1 = 2;
	if (p11->C_GetSlotList(FALSE, slotList, &numSlots1) != CKR_BUFFER_TOO_SMALL) {
		printf("    C_GetSlotList(2) didn't return CKR_BUFFER_TOO_SMALL\n");
		errors++;
	}

	if (p11->C_GetSlotList(FALSE, slotList, &numSlots) != CKR_OK) {
		printf("    C_GetSlotList(3) didn't return CKR_OK\n");
		return ++errors;
	}

	if (p11->C_GetSlotList(1, slotList, &numSlots) != CKR_OK) {
		printf("    C_GetSlotList(4) didn't return CKR_OK\n");
		return ++errors;
	}
	if (numSlots < 1) {
		printf("    C_GetSlotList(4) didn't return a slot (card inserted?)\n");
		return ++errors;
	}

	if (p11->C_GetSlotList(1, slotList, NULL_PTR) != CKR_ARGUMENTS_BAD) {
		printf("    C_GetSlotList(5) didn't return CKR_ARGUMENTS_BAD\n");
		return ++errors;
	}

	if (p11->C_Finalize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Finalize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}
	if (p11->C_GetSlotList(FALSE, slotList, &numSlots) != CKR_CRYPTOKI_NOT_INITIALIZED) {
		printf("    C_GetSlotList(6) didn't return CKR_CRYPTOKI_NOT_INITIALIZED\n");
		errors++;
	}

	return errors;
}
