/*
 * pkcs11 low level testing
 *
 * Copyright (C) 2002  Zetes
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "pkcs11-lowlevel.h"

int c_GetAttributeValue()
{
	int errors = 0;
	CK_SESSION_HANDLE session;
	CK_OBJECT_HANDLE object;
	CK_OBJECT_CLASS cls;
	CK_ATTRIBUTE attr = {CKA_CLASS, &cls, sizeof(CK_OBJECT_CLASS)};
	CK_RV rv;

	printf("C_GetAttributeValue\n");

	printf("  Cat 1\n");

	if (p11->C_Initialize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Initialize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}

	if (p11->C_FindObjectsFinal(12345) != CKR_SESSION_HANDLE_INVALID) {
		printf("    ERR: C_FindObjectsFinal(1) didn't return CKR_SESSION_HANDLE_INVALID\n");
		errors++;
	}

	session = getSessionInFirstSlot();
	object = find_object(session, CKO_CERTIFICATE, 0);

	if (rv = (p11->C_GetAttributeValue(session, object, &attr, 1) != CKR_OK)) {
		printf("    ERR: C_GetAttributeValue(2) didn't return CKR_OK but %s\n", CKR2Str(rv));
		errors++;
	}

	printf("  Cat 2\n");

	if (rv = (p11->C_GetAttributeValue(session, 12345, &attr, 1) != CKR_OBJECT_HANDLE_INVALID)) {
		printf("    ERR: C_GetAttributeValue(1) didn't return CKR_OBJECT_HANDLE_INVALID but %s\n", CKR2Str(rv));
		errors++;
	}

	printf("  Cat 3\n");

	attr.type = CKA_KEY_TYPE;
	if (rv = (p11->C_GetAttributeValue(session, object, &attr, 1) != CKR_ATTRIBUTE_TYPE_INVALID)) {
		printf("    ERR: C_GetAttributeValue(2) didn't return CKR_ATTRIBUTE_TYPE_INVALID but %s\n", CKR2Str(rv));
		errors++;
	}

	attr.type = CKA_CLASS;
	attr.pValue = NULL_PTR;
	if (rv = (p11->C_GetAttributeValue(session, object, &attr, 1) != CKR_OK)) {
		printf("    ERR: C_GetAttributeValue(3) didn't return CKR_OK but %s\n", CKR2Str(rv));
		errors++;
	}
	if (attr.ulValueLen != sizeof(CK_OBJECT_CLASS)) {
		printf("    ERR: C_GetAttributeValue(3) returned the wrong attribute length %s\n");
		errors++;
	}

	attr.pValue = &cls;
	if (rv = (p11->C_GetAttributeValue(session, object, &attr, 1) != CKR_OK)) {
		printf("    ERR: C_GetAttributeValue(4) didn't return CKR_OK but %s\n", CKR2Str(rv));
		errors++;
	}
	if (*((CK_OBJECT_CLASS *) attr.pValue) != CKO_CERTIFICATE) {
		printf("    ERR: C_GetAttributeValue(4) returned the wrong attribute value %s\n");
		errors++;
	}

	if (p11->C_Finalize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Finalize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}
	if (p11->C_GetAttributeValue(session, object, &attr, 1) != CKR_CRYPTOKI_NOT_INITIALIZED) {
		printf("    ERR: C_GetAttributeValue(5) didn't return CKR_CRYPTOKI_NOT_INITIALIZED\n");
		errors++;
	}

	return errors;
}
