/**********************************************************
 *
 * scgui_gtk.c
 *
 * Copyright (C) 2003 Zetes PASS
 *
 **********************************************************/

#include "scgui.h"
#include <stdio.h>
#include <string.h>

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#define MAX_PIN_LENGTH 12

typedef struct {
	char pin[MAX_PIN_LENGTH+1];
	int ok; /* ok = 1, cancel = 0 */
} EnterPinData_t;

GtkWidget *_window; /* dialog window ==> needed for lookup_widget */

GtkWidget* create_dialog(const char *title, const char *msg, const char *btn_ok, const char *btn_cancel, scgui_param_t, EnterPinData_t *mydata);
static void on_btnOK_clicked1(GtkButton *button, EnterPinData_t *user_data);
static void on_btnCancel_clicked1(GtkButton *button, EnterPinData_t *user_data);
static GtkWidget *getmemimage(const guchar *buf, int size);

scgui_ret_t scgui_init(void)
{
	static int initialized = FALSE;

	if (!initialized) {
                gtk_set_locale();
		gtk_init(NULL, NULL);
		initialized = TRUE;
	}

	return SCGUI_OK;
}

/* fixme : need to check initial value of len */
scgui_ret_t scgui_enterpin(const char *title, 
			   const char *msg, 
			   char *pin, 
			   int *len, 
			   const char *btn_ok, 
			   const char *btn_cancel, 
			   const char *pin_too_short, 
			   scgui_param_t sign_icon)
{
	EnterPinData_t data;

	_window = create_dialog(title, msg, btn_ok, btn_cancel, sign_icon, &data);

	pin[0] = '\0';
	data.pin[0] = '\0';

	gtk_window_position(GTK_WINDOW(_window), GTK_WIN_POS_CENTER);
	gtk_widget_show(_window);

	gtk_quit_add_destroy(1, GTK_OBJECT(_window));
	gtk_main();

	*len = strlen(data.pin);
	strcpy(pin, data.pin);

	return data.ok ? SCGUI_OK : SCGUI_CANCEL;
}

SCGUI_API scgui_ret_t scgui_ask_message(const char *title, const char *short_msg, const char *long_msg, const char *btn_ok, const char *btn_cancel, const char *pinpad_reader)
{
	return SCGUI_OK;
}

#include "signbmp.c"

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)

GtkWidget *getmemimage(const guchar *buf, int size)
{
        GdkPixbufLoader *loader;
        GdkPixbuf       *pixbuf;

        loader = gdk_pixbuf_loader_new();
        gdk_pixbuf_loader_write(loader, buf, size, NULL);
        gdk_pixbuf_loader_close(loader, NULL);
        pixbuf = gdk_pixbuf_loader_get_pixbuf(loader);

        return gtk_image_new_from_pixbuf(pixbuf);
}

GtkWidget* lookup_widget(GtkWidget *widget, const gchar *widget_name)
{
        GtkWidget *parent, *found_widget;

        for (;;)
    {
                if (GTK_IS_MENU (widget))
                        parent = gtk_menu_get_attach_widget (GTK_MENU (widget));
                else
                        parent = widget->parent;
                if (!parent)
                        parent = (GtkWidget*) g_object_get_data (G_OBJECT (widget), "GladeParentKey");
                if (parent == NULL)
                        break;
                widget = parent;
        }

        found_widget = (GtkWidget*) g_object_get_data (G_OBJECT (widget), widget_name);
        if (!found_widget)
                g_warning ("Widget not found: %s", widget_name);

        return found_widget;
}

GtkWidget *gtk_button_new_with_icon(const char *text, const char *stock)
{
        GtkWidget *button, *label;
        GtkStockItem item;

        button = gtk_button_new();
        label = gtk_label_new_with_mnemonic(text);
        gtk_label_set_mnemonic_widget((GtkLabel *)label, button);

        if (gtk_stock_lookup(stock, &item)) {
                GtkWidget *image, *hbox, *align;

                image = gtk_image_new_from_stock(stock, GTK_ICON_SIZE_BUTTON);
                hbox = gtk_hbox_new(FALSE, 2);
                align = gtk_alignment_new(0.5, 0.5, 0.0, 0.0);
                gtk_box_pack_start((GtkBox *)hbox, image, FALSE, FALSE, 0);
                gtk_box_pack_end((GtkBox *)hbox, label, FALSE, FALSE, 0);
                gtk_container_add((GtkContainer *)align, hbox);
                gtk_container_add((GtkContainer *)button, align);
                gtk_widget_show_all(align);
        } else {
                gtk_misc_set_alignment((GtkMisc *)label, 0.5, 0.5);
                gtk_container_add((GtkContainer *)button, label);
                gtk_widget_show(label);
        }

        return button;
}

void on_btnOK_clicked1(GtkButton *button, EnterPinData_t *user_data)
{
        GtkWidget *widget = lookup_widget(_window, "txtPIN");
        strcpy(user_data->pin, gtk_entry_get_text(GTK_ENTRY(widget)));
        user_data->ok = 1;    
        gtk_main_quit();
}

void on_btnCancel_clicked1(GtkButton *button, EnterPinData_t *user_data)
{    
        user_data->ok = 0;
        user_data->pin[0] = '\0';
        gtk_main_quit();
}

GtkWidget*
create_dialog (const char      *title, 
               const char      *msg, 
               const char      *btn_ok, 
               const char      *btn_cancel, 
               scgui_param_t   sign_icon, 
               EnterPinData_t  *mydata)
{
        GtkWidget *dialog1;
        GtkWidget *dialog_vbox3;
        GtkWidget *hbox2;
        GtkWidget *fixed3;
        GtkWidget *image2;
        GtkWidget *vbox1;
        GtkWidget *lblMessage;
        GtkWidget *label7;
        GtkWidget *hbox3;
        GtkWidget *lblPIN;
        GtkWidget *txtPIN;
        GtkWidget *label6;
        GtkWidget *dialog_action_area3;
        GtkWidget *cancelbutton3;
        GtkWidget *okbutton3;

        dialog1 = gtk_dialog_new ();
        gtk_window_set_title (GTK_WINDOW (dialog1), title);
        gtk_window_set_position (GTK_WINDOW (dialog1), GTK_WIN_POS_CENTER);
        gtk_window_set_modal (GTK_WINDOW (dialog1), TRUE);
        gtk_window_set_resizable (GTK_WINDOW (dialog1), FALSE);

        dialog_vbox3 = GTK_DIALOG (dialog1)->vbox;
        gtk_widget_show (dialog_vbox3);

        hbox2 = gtk_hbox_new (FALSE, 0);
        gtk_widget_show (hbox2);
        gtk_box_pack_start (GTK_BOX (dialog_vbox3), hbox2, TRUE, TRUE, 0);

        fixed3 = gtk_fixed_new ();
        gtk_widget_show (fixed3);
        gtk_box_pack_start (GTK_BOX (hbox2), fixed3, FALSE, FALSE, 0);

        /* SK */
        if (SCGUI_SIGN_ICON == sign_icon)
                image2 = getmemimage(signimg, sizeof(signimg));
        else
                image2 = GTK_WIDGET(gtk_image_new());

        gtk_widget_show (image2);
        gtk_fixed_put (GTK_FIXED (fixed3), image2, 0, 0);
        gtk_widget_set_size_request (image2, 64, 64);

        vbox1 = gtk_vbox_new (FALSE, 0);
        gtk_widget_show (vbox1);
        gtk_box_pack_start (GTK_BOX (hbox2), vbox1, TRUE, TRUE, 0);

        lblMessage = gtk_label_new (msg);
        gtk_widget_show (lblMessage);
        gtk_box_pack_start (GTK_BOX (vbox1), lblMessage, FALSE, FALSE, 8);
        gtk_widget_set_size_request (lblMessage, 432, 112);
        gtk_label_set_use_markup (GTK_LABEL (lblMessage), TRUE);
        gtk_label_set_justify (GTK_LABEL (lblMessage), GTK_JUSTIFY_LEFT);
        gtk_misc_set_padding (GTK_MISC (lblMessage), 0, 2);

        label7 = gtk_label_new ("");
        gtk_widget_show (label7);
        gtk_box_pack_start (GTK_BOX (vbox1), label7, FALSE, FALSE, 0);
        gtk_label_set_justify (GTK_LABEL (label7), GTK_JUSTIFY_LEFT);

        hbox3 = gtk_hbox_new (FALSE, 0);
        gtk_widget_show (hbox3);
        gtk_box_pack_start (GTK_BOX (vbox1), hbox3, TRUE, TRUE, 0);

        lblPIN = gtk_label_new ("PIN:");
        gtk_widget_show (lblPIN);
        gtk_box_pack_start (GTK_BOX (hbox3), lblPIN, FALSE, FALSE, 0);
        gtk_widget_set_size_request (lblPIN, 38, 18);
        gtk_label_set_justify (GTK_LABEL (lblPIN), GTK_JUSTIFY_LEFT);

        txtPIN = gtk_entry_new ();
        gtk_widget_show (txtPIN);
        gtk_box_pack_start (GTK_BOX (hbox3), txtPIN, FALSE, FALSE, 0);
        gtk_widget_set_size_request (txtPIN, 158, 26);
        gtk_entry_set_max_length (GTK_ENTRY (txtPIN), 12);
        gtk_entry_set_visibility (GTK_ENTRY (txtPIN), FALSE);

        label6 = gtk_label_new ("");
        gtk_widget_show (label6);
        gtk_box_pack_start (GTK_BOX (vbox1), label6, FALSE, FALSE, 0);
        gtk_label_set_justify (GTK_LABEL (label6), GTK_JUSTIFY_LEFT);

        dialog_action_area3 = GTK_DIALOG (dialog1)->action_area;
        gtk_widget_show (dialog_action_area3);
        gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area3), GTK_BUTTONBOX_END);

        /* SK */
#if 0
        cancelbutton3 = gtk_button_new_from_stock ("gtk-cancel"); 
        g_object_set(GTK_OBJECT(cancelbutton3), "label", btn_cancel, NULL); 
#endif
        cancelbutton3 = gtk_button_new_with_icon(btn_cancel, "gtk-cancel");
        gtk_widget_show (cancelbutton3);
        gtk_dialog_add_action_widget (GTK_DIALOG (dialog1), cancelbutton3, GTK_RESPONSE_CANCEL);
        GTK_WIDGET_SET_FLAGS (cancelbutton3, GTK_CAN_DEFAULT);

        okbutton3 = gtk_button_new_with_icon(btn_ok, "gtk-ok"); 
        gtk_widget_show (okbutton3);
        gtk_dialog_add_action_widget (GTK_DIALOG (dialog1), okbutton3, GTK_RESPONSE_OK);
        GTK_WIDGET_SET_FLAGS (okbutton3, GTK_CAN_DEFAULT);

        /* Store pointers to all widgets, for use by lookup_widget(). */
        GLADE_HOOKUP_OBJECT_NO_REF (dialog1, dialog1, "dialog1");
        GLADE_HOOKUP_OBJECT_NO_REF (dialog1, dialog_vbox3, "dialog_vbox3");
        GLADE_HOOKUP_OBJECT (dialog1, hbox2, "hbox2");
        GLADE_HOOKUP_OBJECT (dialog1, fixed3, "fixed3");
        GLADE_HOOKUP_OBJECT (dialog1, image2, "image2");
        GLADE_HOOKUP_OBJECT (dialog1, vbox1, "vbox1");
        GLADE_HOOKUP_OBJECT (dialog1, lblMessage, "lblMessage");
        GLADE_HOOKUP_OBJECT (dialog1, label7, "label7");
        GLADE_HOOKUP_OBJECT (dialog1, hbox3, "hbox3");
        GLADE_HOOKUP_OBJECT (dialog1, lblPIN, "lblPIN");
        GLADE_HOOKUP_OBJECT (dialog1, txtPIN, "txtPIN");
        GLADE_HOOKUP_OBJECT (dialog1, label6, "label6");
        GLADE_HOOKUP_OBJECT_NO_REF (dialog1, dialog_action_area3, "dialog_action_area3");
        GLADE_HOOKUP_OBJECT (dialog1, cancelbutton3, "cancelbutton3");
        GLADE_HOOKUP_OBJECT (dialog1, okbutton3, "okbutton3");

        /* SK */
        /*mydata->entry = GTK_ENTRY(txtPIN);*/
        gtk_signal_connect(GTK_OBJECT(okbutton3), "clicked", GTK_SIGNAL_FUNC (on_btnOK_clicked1), mydata);    
        gtk_signal_connect(GTK_OBJECT(txtPIN), "activate", GTK_SIGNAL_FUNC(on_btnOK_clicked1), mydata);
        gtk_signal_connect(GTK_OBJECT(cancelbutton3), "clicked", GTK_SIGNAL_FUNC (on_btnCancel_clicked1), mydata);

        return dialog1;
}
