// Include private header
// For compilers that support precompilation
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif

#include <wx/image.h>
#include <wx/statline.h>
#include <wx/spinbutt.h>
#include <wx/spinctrl.h>
#include <wx/splitter.h>
#include <wx/listctrl.h>
#include <wx/treectrl.h>
#include <wx/notebook.h>
#include <wx/grid.h>
#include <wx/font.h>

#include "wxwalldlg.h"
#include "eidlib.h"

struct tMapFunc
{
    const char *pszFunc;
    const char *pszMsg;
};

BEGIN_EVENT_TABLE(CWallDialog, wxDialog)
    EVT_BUTTON(ID_BUTTON_YES, CWallDialog::OnButtonYes)
    EVT_BUTTON(ID_BUTTON_NO, CWallDialog::OnButtonNo)
    EVT_BUTTON(ID_BUTTON_ALWAYS, CWallDialog::OnButtonAlways)
    EVT_BUTTON(ID_BUTTON_ALWAYS_ALL, CWallDialog::OnButtonAlwaysToAll)
END_EVENT_TABLE()

CWallDialog::CWallDialog(wxWindow *parent) : wxDialog(parent, -1, _("EID Card Access Confirmation"), wxDefaultPosition, 
                                                      wxDefaultSize)
{
    MyDialogFunc(this, TRUE);
}

void CWallDialog::OnButtonYes(wxCommandEvent& event)
{
    EndModal(ID_BUTTON_YES);
}

void CWallDialog::OnButtonNo(wxCommandEvent& event)
{
    EndModal(ID_BUTTON_NO);
}

void CWallDialog::OnButtonAlways(wxCommandEvent& event)
{
    EndModal(ID_BUTTON_ALWAYS);
}

void CWallDialog::OnButtonAlwaysToAll(wxCommandEvent& event)
{
    EndModal(ID_BUTTON_ALWAYS_ALL);
}

void CWallDialog::FillData(const wxString & strApplication, const wxString & strFunction)
{
    struct tMapFunc MsgMapFunc[] =
    {
        {"id", _("Read Identity data")},
        {"address", _("Read Address data")},
        {"photo", _("Read Picture data")},
        {"readfile", _("Read a file")},
        {"writefile", _("Write a file")},
        {"sendapdu", _("Send an unknown command")},
        {NULL}
    };    
        
    wxStaticText *pAppText = (wxStaticText *)FindWindow(ID_TEXT_APP_NAME);
    if(pAppText != NULL)
    {
        pAppText->SetLabel(strApplication);
    }
    wxStaticText *pFuncText = (wxStaticText *)FindWindow(ID_TEXT_FUNCNAME);
    if(pFuncText != NULL)
    {
        BOOL bFound = FALSE;
        unsigned int i = 0;
	    for (i = 0; MsgMapFunc[i].pszFunc != NULL; i++) 
        {
		    if (0 == strcmp(MsgMapFunc[i].pszFunc, strFunction.GetData()))
            {
                bFound = TRUE;
                break;
            }
	    }
        if (bFound)
        {
            pFuncText->SetLabel(MsgMapFunc[i].pszMsg);
        }
    }
}

// Implement window functions

wxSizer *MyDialogFunc( wxWindow *parent, bool call_fit, bool set_sizer )
{
    wxBoxSizer *item0 = new wxBoxSizer( wxHORIZONTAL );

    wxBoxSizer *item1 = new wxBoxSizer( wxVERTICAL );

    wxBoxSizer *item2 = new wxBoxSizer( wxHORIZONTAL );

    wxStaticBitmap *item3 = new wxStaticBitmap( parent, ID_STATICBITMAP_WARNING, MyBitmapsFunc( 0 ), wxDefaultPosition, wxDefaultSize );
    item2->Add( item3, 0, wxALIGN_TOP|wxALL, 5 );

    wxBoxSizer *item4 = new wxBoxSizer( wxVERTICAL );

    wxStaticText *item5 = new wxStaticText( parent, ID_TEXT_MAIN, _("An Application wants to access the card !"), wxDefaultPosition, wxDefaultSize, 0 );
    wxFont oStaticFont5 = item5->GetFont();
    oStaticFont5.SetWeight(wxBOLD);
    item5->SetFont(oStaticFont5);
    item4->Add( item5, 0, wxALIGN_LEFT|wxALL, 5 );

    item4->Add( 20, 10, 0, wxALIGN_LEFT|wxALL, 5 );

    wxStaticText *item6 = new wxStaticText( parent, ID_TEXT_APPLICATION, _("Application:"), wxDefaultPosition, wxDefaultSize, 0 );
    wxFont oStaticFont6 = item6->GetFont();
    oStaticFont6.SetUnderlined(TRUE);
    //oStaticFont6.SetWeight(wxBOLD);
    item6->SetFont(oStaticFont6);
    item4->Add( item6, 0, wxALIGN_LEFT|wxALL, 5 );

    wxStaticText *item7 = new wxStaticText( parent, ID_TEXT_APP_NAME, wxT(""), wxDefaultPosition, wxDefaultSize, 0 );
    item4->Add( item7, 0, wxALIGN_LEFT|wxEXPAND|wxALL, 5 );

    item4->Add( 20, 10, 0, wxALIGN_LEFT|wxALL, 5 );

    wxStaticText *item8 = new wxStaticText( parent, ID_TEXT_FUNCTION, _("Function:"), wxDefaultPosition, wxDefaultSize, 0 );
    wxFont oStaticFont8 = item8->GetFont();
    oStaticFont8.SetUnderlined(TRUE);
  //  oStaticFont8.SetWeight(wxBOLD);
    item8->SetFont(oStaticFont8);
    item4->Add( item8, 0, wxALIGN_LEFT|wxALL, 5 );

    wxStaticText *item9 = new wxStaticText( parent, ID_TEXT_FUNCNAME, wxT(""), wxDefaultPosition, wxDefaultSize, 0 );
    item4->Add( item9, 0, wxALIGN_LEFT|wxEXPAND|wxALL, 5 );

    item4->Add( 20, 10, 0, wxALIGN_LEFT|wxALL, 5 );

    wxStaticText *item14 = new wxStaticText( parent, ID_TEXT_FUNCNAME, _("Do you want to accept it ?"), wxDefaultPosition, wxDefaultSize, 0 );
    wxFont oStaticFont14 = item14->GetFont();
    oStaticFont14.SetWeight(wxBOLD);
    item14->SetFont(oStaticFont14);
    item4->Add( item14, 0, wxALIGN_LEFT|wxALL, 5 );

    item2->Add( item4, 0, wxALIGN_LEFT|wxEXPAND|wxALL, 5 );

    item1->Add( item2, 0, wxALIGN_LEFT|wxALL, 5 );

    wxBoxSizer *item10 = new wxBoxSizer( wxHORIZONTAL );

    wxButton *item11 = new wxButton( parent, ID_BUTTON_YES, _("Yes"), wxDefaultPosition, wxDefaultSize, 0 );
    item10->Add( item11, 0, wxALIGN_CENTRE|wxALL, 5 );

    wxButton *item12 = new wxButton( parent, ID_BUTTON_NO, _("No"), wxDefaultPosition, wxDefaultSize, 0 );
    item10->Add( item12, 0, wxALIGN_CENTRE|wxALL, 5 );

    wxButton *item13 = new wxButton( parent, ID_BUTTON_ALWAYS, _("Always"), wxDefaultPosition, wxDefaultSize, 0 );
    item10->Add( item13, 0, wxALIGN_CENTRE|wxALL, 5 );

    wxButton *item15 = new wxButton( parent, ID_BUTTON_ALWAYS_ALL, _("Always to All"), wxDefaultPosition, wxDefaultSize, 0 );
    item10->Add( item15, 0, wxALIGN_CENTRE|wxALL, 5 );

    item1->Add( item10, 0, wxALIGN_CENTRE|wxALL, 5 );

    item0->Add( item1, 0, wxALIGN_CENTRE|wxALL, 5 );

    if (set_sizer)
    {
        parent->SetAutoLayout( TRUE );
        parent->SetSizer( item0 );
        if (call_fit)
        {
            item0->Fit( parent );
            item0->SetSizeHints( parent );
        }
    }
    
    return item0;
}

// Implement menubar functions

// Implement toolbar functions

// Implement bitmap functions

wxBitmap MyBitmapsFunc( size_t index )
{
    if (index == 0)
    {
        static const unsigned char data[] = 
        {
            0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,
            128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,
            128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,
            0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,
            128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,
            128,0,128,128,0,128,128,0,128,128,0,128,128,245,247,15,255,255,7,199,213,56,49,96,197,
            0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,
            128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,
            128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,
            0,128,128,0,128,128,243,243,0,249,246,0,255,255,0,255,255,0,194,193,26,36,68,170,0,
            128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,
            128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,
            0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,235,
            234,0,235,234,0,253,250,3,255,255,42,255,255,0,255,255,0,81,83,79,34,63,165,0,128,
            128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,
            0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,
            128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,234,230,0,235,234,
            0,254,253,23,255,255,104,255,254,13,255,255,0,194,193,26,9,14,123,0,128,128,0,128,128,
            0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,
            128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,
            128,0,128,128,0,128,128,0,128,128,0,128,128,229,225,0,229,225,0,242,235,0,255,255,24,
            255,255,49,255,255,34,249,246,0,255,255,0,70,70,85,29,53,154,0,128,128,0,128,128,0,
            128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,
            128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,
            0,128,128,0,128,128,0,128,128,233,225,1,234,230,0,249,244,4,255,255,17,255,255,9,255,
            255,42,255,248,0,255,255,0,194,193,26,6,13,116,0,128,128,0,128,128,0,128,128,0,128,
            128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,
            0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,
            128,128,231,221,0,231,221,0,242,235,0,255,255,14,255,255,9,255,255,0,255,255,28,255,255,
            22,255,245,0,255,253,0,70,70,85,29,53,154,0,128,128,0,128,128,0,128,128,0,128,128,
            0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,
            128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,233,225,
            1,233,225,1,255,245,3,255,255,19,254,247,3,195,184,2,255,255,9,255,255,34,255,248,0,
            255,255,0,179,172,31,9,14,123,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,
            128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,
            128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,233,219,0,233,219,0,242,227,0,
            255,255,14,167,166,17,0,0,1,0,0,1,0,0,9,227,226,35,255,255,19,252,240,0,255,
            250,0,70,70,85,29,53,154,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,
            128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,
            0,128,128,0,128,128,0,128,128,0,128,128,233,219,0,233,219,0,255,240,3,255,255,19,0,
            0,7,0,0,9,10,0,48,0,0,50,92,77,46,255,255,30,255,243,0,255,250,0,179,172,
            31,4,12,127,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,
            0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,
            128,128,0,128,128,230,212,1,230,212,1,242,227,0,255,255,14,255,255,11,0,0,1,0,0,
            22,27,3,71,2,0,69,79,59,34,255,255,21,255,255,22,255,235,0,255,243,0,67,56,84,
            30,58,163,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,
            128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,
            128,226,211,10,233,219,0,250,232,3,255,255,19,255,255,3,16,10,6,0,0,27,21,0,62,
            2,0,69,115,89,34,255,255,3,255,255,36,255,237,0,255,247,0,162,152,40,9,17,131,0,
            128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,
            128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,230,212,1,230,212,1,
            242,218,1,255,246,14,255,254,13,255,255,0,89,73,21,0,0,46,27,3,71,27,3,71,168,
            144,21,255,255,0,255,255,30,255,249,21,251,229,0,255,243,0,46,46,98,34,63,165,0,128,
            128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,
            0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,230,212,1,230,212,1,248,229,4,255,
            251,19,255,240,3,255,255,0,180,163,1,0,0,46,55,33,104,61,39,79,227,204,2,255,247,
            0,255,247,13,255,255,36,255,231,0,255,241,0,162,152,40,6,15,133,0,128,128,0,128,128,
            0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,
            128,128,0,128,128,0,128,128,229,206,0,229,206,0,235,213,0,255,240,13,255,247,13,255,232,
            0,255,253,0,208,188,0,0,0,34,93,78,166,67,56,84,255,250,0,255,237,0,255,232,0,
            255,255,30,255,245,18,255,227,0,249,225,0,50,50,96,37,68,163,0,128,128,0,128,128,0,
            128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,
            128,0,128,128,218,198,21,229,206,0,242,218,1,255,245,18,255,234,5,255,231,0,255,241,0,
            255,232,0,39,24,34,93,78,166,100,80,50,255,245,0,255,232,0,255,228,0,255,244,14,255,
            255,30,250,222,0,255,239,0,152,137,44,11,25,130,0,128,128,0,128,128,0,128,128,0,128,
            128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,230,202,0,
            230,202,0,233,207,0,254,231,8,255,240,13,255,228,0,255,228,0,255,232,0,255,255,0,89,
            73,21,0,0,124,168,144,21,255,250,0,255,231,0,255,227,0,255,231,6,255,255,30,254,231,
            8,248,219,0,255,227,0,36,39,101,39,71,164,0,128,128,0,128,128,0,128,128,0,128,128,
            0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,225,203,14,230,202,0,243,
            213,0,255,238,17,255,234,8,255,227,0,255,227,0,255,228,0,255,253,0,140,123,29,0,0,
            106,204,171,6,255,248,0,255,228,0,255,225,0,255,225,0,255,247,22,255,248,26,249,214,1,
            255,232,0,152,137,44,11,25,130,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,
            128,128,0,128,128,0,128,128,0,128,128,230,202,0,230,202,0,236,205,0,254,226,6,255,241,
            17,255,225,0,255,223,0,255,223,0,255,225,0,255,241,0,195,165,15,2,0,69,237,202,1,
            255,239,0,255,225,0,255,223,0,255,221,0,255,231,6,255,255,36,254,226,6,255,221,0,243,
            213,0,43,44,98,39,72,169,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,
            128,0,128,128,0,128,128,218,198,21,232,201,0,243,210,0,255,238,17,254,231,8,255,221,0,
            255,221,0,255,223,0,255,223,0,255,228,0,249,214,1,29,16,67,255,223,0,255,232,0,255,
            223,0,255,221,0,255,221,0,255,219,0,255,248,26,255,249,29,249,214,1,255,232,0,144,128,
            49,15,30,133,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,
            232,198,0,232,198,0,237,202,1,254,222,11,255,238,17,255,221,0,255,219,0,255,219,0,255,
            219,0,255,221,0,255,225,0,255,228,0,195,165,15,255,228,0,255,225,0,255,219,0,255,219,
            0,255,221,0,255,217,0,254,226,6,255,255,42,255,228,10,252,214,0,255,221,0,40,41,100,
            40,74,171,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,0,128,128,231,197,5,232,
            198,0,247,208,2,255,236,20,255,228,10,255,217,0,255,217,0,255,219,0,255,219,0,255,223,
            0,255,235,0,255,237,0,255,245,0,255,235,0,255,232,0,255,219,0,255,219,0,255,219,0,
            255,217,0,255,214,0,255,242,25,255,253,37,253,213,0,255,227,0,152,137,44,11,25,130,0,
            128,128,0,128,128,0,128,128,0,128,128,0,128,128,229,191,0,229,191,0,236,198,0,254,222,
            11,255,232,17,255,217,0,255,214,0,255,214,0,255,217,0,255,219,0,255,235,0,204,171,6,
            0,0,18,0,0,7,39,24,34,252,214,0,255,225,0,255,217,0,255,217,0,255,214,0,255,
            213,0,255,220,3,255,253,37,254,222,11,255,211,0,245,206,0,46,46,98,39,71,164,0,128,
            128,0,128,128,0,128,128,0,128,128,213,186,27,229,191,0,241,201,0,255,227,16,255,221,6,
            255,213,0,255,211,0,255,214,0,255,214,0,255,219,0,255,232,0,36,25,17,0,0,1,0,
            0,27,0,0,50,115,89,34,255,241,0,255,214,0,255,214,0,255,213,0,255,213,0,255,213,
            0,255,233,20,255,239,28,249,204,0,255,225,0,136,117,53,16,30,132,0,128,128,0,128,128,
            0,128,128,229,191,0,229,191,0,234,193,0,252,209,7,255,226,13,255,214,0,255,211,0,255,
            211,0,255,211,0,255,211,0,255,217,0,255,223,0,0,0,4,0,0,18,49,26,97,27,8,
            105,122,98,90,255,237,0,255,214,0,255,211,0,255,211,0,255,211,0,255,211,0,255,218,5,
            255,239,28,254,213,6,254,207,0,241,201,0,19,24,111,66,16,143,0,128,128,0,128,128,227,
            184,0,227,184,0,234,193,0,254,213,6,255,218,5,255,214,0,255,214,0,255,214,0,255,214,
            0,255,214,0,255,217,0,255,231,0,79,59,34,0,0,22,27,8,105,190,178,255,173,158,83,
            255,228,0,255,214,0,255,214,0,255,214,0,255,214,0,255,213,0,255,214,0,255,226,13,254,
            213,6,246,200,0,255,214,0,88,78,78,66,16,143,0,128,128,0,128,128,200,176,37,222,181,
            0,229,186,0,241,197,0,246,199,0,245,199,1,245,201,1,245,201,1,245,199,1,245,201,1,
            247,202,1,255,209,0,255,217,0,131,105,33,122,98,90,179,151,61,255,211,0,250,203,0,246,
            200,0,245,201,1,245,199,1,245,201,1,245,199,1,246,200,0,246,200,0,241,197,0,239,193,
            0,255,211,0,136,117,53,6,13,116,0,128,128,0,128,128,154,152,94,214,172,0,218,177,0,
            222,181,0,223,179,0,223,179,0,223,179,0,223,179,0,223,179,0,223,179,0,223,179,0,226,
            182,0,229,186,0,250,203,0,252,203,0,241,193,0,226,182,0,224,180,0,223,179,0,223,179,
            0,223,179,0,223,179,0,223,179,0,223,179,0,224,180,0,227,184,0,239,193,0,254,207,0,
            80,71,81,19,24,111,0,128,128,0,128,128,0,128,128,182,163,54,218,177,0,203,165,2,205,
            164,0,205,166,0,205,164,0,205,164,0,205,164,0,205,164,0,205,166,0,205,164,0,206,165,
            0,207,167,0,207,167,0,206,165,0,206,165,0,205,166,0,205,166,0,205,164,0,205,164,0,
            205,166,0,205,164,0,205,164,0,206,165,0,214,172,0,221,178,2,129,107,54,13,19,115,28,
            31,106,0,128,128,0,128,128,0,128,128,0,128,128,51,86,167,45,48,106,49,48,96,50,48,
            96,50,48,96,50,48,96,50,48,96,50,48,96,50,48,96,50,48,96,50,48,95,50,48,95,
            50,48,95,50,48,95,50,48,95,50,48,96,50,48,96,50,48,96,50,48,96,50,48,96,50,
            48,96,50,48,96,49,48,96,53,50,93,46,46,98,13,19,115,28,31,106,0,128,128,0,128,
            128,0,128,128,0,128,128,0,128,128,0,128,128,49,96,197,40,74,171,40,74,171,41,76,172,
            41,76,172,41,76,172,41,76,172,41,76,172,41,76,172,41,76,172,41,76,172,41,76,172,41,
            76,172,41,76,172,41,76,172,41,76,172,41,76,172,41,76,172,41,76,172,41,76,172,41,76,
            172,41,76,172,41,76,172,42,76,171,44,77,168,46,81,173,0,128,128,0,128,128
        };
        wxImage image( 32, 32, (unsigned char*)data, TRUE );
        image.SetMaskColour(0, 128, 128);
        wxBitmap bitmap( image );
        return bitmap;
    }
    if (index == 1)
    {
        /* XPM */
        static const char *xpm_data[] = {
        /* columns rows colors chars-per-pixel */
        "32 32 20 1",
        "  c None",
        "a c #808000",
        "b c #C0C0C0",
        "c c #868686",
        "d c #999999",
        "e c #FFFF00",
        "f c #999900",
        "g c #A0A0A4",
        "h c #008080",
        "i c #969696",
        "j c #B2B2B2",
        "k c #FFFFFF",
        "l c #040404",
        "n c #777777",
        "o c #D7D7D7",
        "p c #009999",
        "q c #006666",
        "r c #CCCCCC",
        "s c #666600",
        "t c #003333",
        /* pixels */
        "c                               ",
        "bc                              ",
        "lbc                             ",
        " lbc                            ",
        "  lbc            n              ",
        "   lbc         cckn             ",
        "    lbc      cckkjbn            ",
        "     lbc   cckkbjjjgn           ",
        "      lbccckkbbjjjjgcn          ",
        "       cckkbbbbjjjccdgn         ",
        "     cckkrrbbbjjccjggddn        ",
        "   cckkrbrbbbjccjjggdgddn       ",
        " cckkrrbrbbjccbjjgjggdddin      ",
        "ckkrrrbrbbccbbjjjjggdgddcin     ",
        "cbbkrbrbccbbbjbjjgjggdddicin    ",
        "ccbbkrccbbbbjbjjjjggdgddcicin   ",
        "cbcbbkbbbbbjbjjjjgjggdddicinn   ",
        "lcbcbbkbbbjbjbjjgjggdgddcicnl   ",
        " lcbcbbkbbbjbjjjjgjggdddinnll   ",
        "  lcbcbbkbjbjjjjgjggdgdnnllnl   ",
        "   lcbcbbkbjbjjjjgjggnnlljhnl   ",
        "    lcbcbbkbjjjjgjgnnlljjokh    ",
        "     lcbcbbkbjjjjcclljjbbokkh   ",
        "      lcbcbbkjjccllsffbbokokkh  ",
        "       lcbcbbcclltsffeaobokokkh ",
        "        lcbccllnltaaeeabobokokhl",
        "         lcbbcnnlltqaahpbobokhhl",
        "          lcccll  lqqqhhpbohhll ",
        "           lll     lqqqhphhll   ",
        "                    lqqhhll     ",
        "                     lqll       ",
        "                      l         "
        };
        wxBitmap bitmap( xpm_data );
        return bitmap;
    }
    return wxNullBitmap;
}
