/////////////////////////////////////////////////////////////////////////////
// Name:        wxmainapp.cpp
// Author:      XX
// Created:     XX/XX/XX
// Copyright:   
/////////////////////////////////////////////////////////////////////////////

// Include private headers
#include "wxmainapp.h"

//------------------------------------------------------------------------------
// MyApp
//------------------------------------------------------------------------------

#ifndef _WIN32
namespace eidlib
{
#endif

MyApp::MyApp()
{
    m_pLocale = NULL;
}

MyApp::~MyApp()
{
    if(m_pLocale)
    {
        delete m_pLocale;
        m_pLocale = NULL;
    }
}

bool MyApp::OnInit()
{
    if(m_pLocale)
    {
        delete m_pLocale;
        m_pLocale = NULL;
    }
    m_pLocale = new wxLocale();
    int iLanguage = MapLanguage();
    wxString strCatalog;

    switch(iLanguage)
    {
    case wxLANGUAGE_DUTCH_BELGIAN:
        strCatalog = wxT("eidlib_nl");
        break;
    case wxLANGUAGE_FRENCH_BELGIAN:
        strCatalog = wxT("eidlib_fr");
        break;
    case wxLANGUAGE_GERMAN:
        strCatalog = wxT("eidlib_de");
        break;
    }
    m_pLocale->Init(iLanguage);
    if(!strCatalog.IsEmpty())
    {
#ifdef _WIN32
        wxString strValue;
        if(wxGetEnv(wxT("SYSTEMROOT"), &strValue))
        {
            m_pLocale->AddCatalogLookupPathPrefix(strValue);
        }
#endif
        m_pLocale->AddCatalog(strCatalog);
    }

    return TRUE;
}

int MyApp::OnExit()
{
    if(m_pLocale)
    {
        delete m_pLocale;
        m_pLocale = NULL;
    }
    return 0;
}

int MyApp::MapLanguage()
{
    int iLanguage = wxLANGUAGE_DEFAULT;
#ifdef _WIN32
    LCID lcid;

   // Get the language code for the current thread
   lcid = GetThreadLocale ();

   switch (lcid)
   {
      case 0x0413:   // Dutch (Standard) 
      case 0x0813:   // Dutch (Belgian) 
        iLanguage = wxLANGUAGE_DUTCH_BELGIAN;  // Always set to Dutch (Belgian)
      break;
      case 0x040c:   // French (Standard) 
      case 0x080c:   // French (Belgian) 
      case 0x0c0c:   // French (Canadian) 
      case 0x100c:   // French (Swiss) 
      case 0x140c:   // French (Luxembourg) 
        iLanguage = wxLANGUAGE_FRENCH_BELGIAN; // Always set to French (Belgian)
      break;
      case 0x0407:   // German (Standard) 
      case 0x0807:   // German (Swiss) 
      case 0x0c07:   // German (Austrian) 
      case 0x1007:   // German (Luxembourg) 
      case 0x1407:   // German (Liechtenstein) 
        iLanguage = wxLANGUAGE_GERMAN; // Always set to German (Standard)
      break;
   }
#endif
   return (iLanguage);    // Return the default language ID
}

#ifndef _WIN32
}
#endif
