// GuiDlg.h : interface of the Gui classes
//
/////////////////////////////////////////////////////////////////////////////

#ifndef __VERIFYDLG_H__
#define __VERIFYDLG_H__

// Include wxWindows' headers

// For compilers that support precompilation
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif

#include <wx/image.h>
#include <wx/statline.h>
#include <wx/spinbutt.h>
#include <wx/spinctrl.h>
#include <wx/splitter.h>
#include <wx/listctrl.h>
#include <wx/treectrl.h>
#include <wx/notebook.h>
#include <wx/grid.h>

#define MAX_PINSIZE     12
#define MIN_PINSIZE      4

#define IDC_STATIC_ICON_VERIFYSMARTCARD 10009
#define IDC_STATIC_LABEL_VERIFYHEADER 10010
#define IDC_STATIC_PIN_LABEL 10011
#define IDC_EDIT_PIN 10012
#define IDC_STATIC_LABEL_VERIFYERROR 10013
#define ID_BUTTON_OK 10014
#define ID_BUTTON_CANCEL 10015

wxSizer *VerifyDialogFunc( wxWindow *parent, bool call_fit = TRUE, bool set_sizer = TRUE );

class CVerifyDlg: public wxDialog
{
public:
    CVerifyDlg(wxWindow *parent);
    void GetPin(char *pPin)
    {
        if(pPin != NULL)
        {
            strcpy(pPin, m_strPin.GetData());
        }
    }

private:
    void OnButtonOK(wxCommandEvent& event);
    void OnButtonCancel(wxCommandEvent& event);

private:
    DECLARE_EVENT_TABLE()

    wxString m_strPin;
};

#define IDC_STATIC_ICON_CHANGESMARTCARD 10016
#define IDC_STATIC_LABEL_CHANGEHEADER 10017
#define IDC_STATIC_OLDPIN_LABEL 10018
#define IDC_EDIT_OLDPIN 10019
#define IDC_STATIC_NEWPIN_LABEL 10020
#define IDC_EDIT_NEWPIN 10021
#define IDC_STATIC_CONFIRMPIN_LABEL 10022
#define IDC_EDIT_CONFIRMPIN 10023
#define IDC_STATIC_LABEL_CHANGEERROR 10024

wxSizer *ChangeDialogFunc( wxWindow *parent, bool call_fit = TRUE, bool set_sizer = TRUE );

class CChangeDlg: public wxDialog
{
public:
    CChangeDlg(wxWindow *parent);
    void GetOldPin(char *pPin)
    {
        if(pPin != NULL)
        {
            strcpy(pPin, m_strPinOld.GetData());
        }
    }

    void GetNewPin(char *pPin)
    {
        if(pPin != NULL)
        {
            strcpy(pPin, m_strPinNew.GetData());
        }
    }

private:
    void OnButtonOK(wxCommandEvent& event);
    void OnButtonCancel(wxCommandEvent& event);

private:
    DECLARE_EVENT_TABLE()

    wxString m_strPinOld;
    wxString m_strPinNew;
};

#endif // __VERIFYDLG_H__
