// Config.h: interface for the CConfig class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CONFIG_H__F1D55E02_1F15_4A9F_A402_2BB87DD17C26__INCLUDED_)
#define AFX_CONFIG_H__F1D55E02_1F15_4A9F_A402_2BB87DD17C26__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifdef _WIN32
#pragma warning(disable:4786 4503)
#endif

#include <string>
#include <vector>
#include <map>

#include <wx/string.h>

namespace eidlib
{

class CConfig  
{
public:
	CConfig();
	virtual ~CConfig();
    
    static void Load();
    static void Unload();
    static const char *GetCertStorePath();
    static const char *GetCRLStorePath();
    static const char *GetHttpStore();
    static char **GetGovCerts();
    static char **GetRootCerts();
    static int AllowTestRoot();
    static int AllowCaching();
    static int GetProgramAccess(char *pszName, char *pszType);
    static void UpdateProgramAccess(char *pszName, char *pszType);
    static const char *GetProxyHost();
    static const char *GetProxyPort();
    static int AllowAutoUpdate();
    static int GetAutoUpdateScheduleDays();
    static const char *GetAutoUpdateVersionURL();
    static const char *GetAutoUpdateDownloadURL();
    static const char *GetAutoUpdateLastCheck();
    static void UpdateLastCheck(char *pszCheck);
    static void LoadAutoUpdate();

protected:
    static const char *CConfig::FindValue(char *pszSection, char *pszKey);
    static void LoadFirewall();

private:
    static char **SplitString(const char *psStr, int iLength, char cSep);
    static wxString GetGlobalDir();

// Members
private:
    static std::map<std::string, std::vector<std::pair<std::string, std::string> > > m_oMapConfig;
    typedef std::map<std::string, std::vector<std::pair<std::string, std::string> > >::iterator ConfigMapIT;
    typedef std::vector<std::pair<std::string, std::string> >::iterator ConfigVecIT;
};

}
#endif // !defined(AFX_CONFIG_H__F1D55E02_1F15_4A9F_A402_2BB87DD17C26__INCLUDED_)
