// TLV.cpp: implementation of the CTLV class.
//
//////////////////////////////////////////////////////////////////////

#include "TLV.h"

namespace eidviewer
{

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CTLV::CTLV()
{
    m_ucTag = 0x00;
}

CTLV::CTLV(const CTLV & oTlv)
{
    m_ucTag = oTlv.m_ucTag;
    m_Data.Append(oTlv.m_Data); 
}

CTLV::CTLV(unsigned char ucTag, unsigned char *pucData, unsigned long ulLen)
{
    m_ucTag = ucTag;
    m_Data.Append(pucData, ulLen); 
}

CTLV::~CTLV()
{

}

void CTLV::SetTag(unsigned char ucTag) 
{ 
    m_ucTag = ucTag; 
}

void CTLV::SetData(unsigned char *pucData, unsigned long ulLen) 
{ 
    m_Data.Append(pucData, ulLen); 
}

unsigned char CTLV::GetTag() 
{
    return m_ucTag; 
}

unsigned char *CTLV::GetData() 
{ 
    return m_Data.GetData(); 
}

unsigned long CTLV::GetLength() 
{
    return m_Data.GetSize(); 
}


} // namespace
