// ApplicationManager.cpp: implementation of the CApplicationManager class.
//
//////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "ApplicationManager.h"
#include "ApplicationObject.h"
#include <stdlib.h>
#include <time.h>

#ifdef _WIN32
    #include "processapi.h"
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CApplicationManager::CApplicationManager() : CManager ("Application")
{
	PASS_INITLOCK (&lock);
}

CApplicationManager::~CApplicationManager()
{
	PASS_LOCK (&lock);
    ULONG32 position = 0; 
    CApplicationObject *pObject = NULL;

	pObject = (CApplicationObject *)m_Applications.GetFirst (&position); 

	while (pObject != NULL) 
	{ 
        delete pObject;
		pObject = (CApplicationObject *) m_Applications.GetNext (&position); 
	} 

    m_Applications.RemoveAll();
	PASS_UNLOCK (&lock); 
	PASS_DESTROYLOCK (&lock);
}

CApplicationObject *CApplicationManager::FindExisting(long lConnID)
{
    CApplicationObject *pObject = NULL;

    PASS_LOCK (&lock);
    ULONG32 position = 0; 

	pObject = (CApplicationObject *)m_Applications.GetFirst (&position); 

	while (pObject != NULL) 
	{ 
		if (pObject->GetConnID() == lConnID) 
		{ 
			// And exit 
			PASS_UNLOCK (&lock); 
			return pObject; 
		} 
		pObject = (CApplicationObject *) m_Applications.GetNext (&position); 
	} 

	PASS_UNLOCK (&lock); 

    return pObject;
}

CApplicationObject * CApplicationManager::FindApplication(SCARDCONTEXT hContext)
{
      CApplicationObject *pApp = (CApplicationObject *)m_Applications.Lookup(hContext);
      return pApp;
}

CApplicationObject *CApplicationManager::CreateApplication(CMessage *pMessage, long lConnID)
{
    CApplicationObject *pApp = NULL;
    if(pMessage != NULL)
    {
        pApp = new CApplicationObject;
        // Create random Context
        time_t ltime = time( NULL );
        srand( ltime );
        SCARDCONTEXT hContext = rand();
        pApp->SetContext(hContext); 
        char szTemp[256] = {0};
        unsigned long lPID = 0;
        ((CGenericMessage *)pMessage)->GetValueForKey("ProcessID", &lPID);
        pApp->SetPID(lPID); 
/*
#ifdef _WIN32
        if(lPID > 0)
        {
            CProcessApi papi;
            if (papi.Init(true))
            {
                DWORD pl = papi.ProcessesGetList();
                if (pl)
                {
                    CProcessApi::tProcessInfo pi;
                    while (papi.ProcessesWalk(pl, &pi))
                    {
                        printf("Process[%d]: %s\n", pi.pid, pi.FileName);
                        if(pi.pid == lPID)
                        {
                            pApp->SetApplicationName(pi.FileName); 
                            break;
                        }
                    }
                }
                papi.ProcessesFreeList(pl);
            }
        }
#endif
*/
        ((CGenericMessage *)pMessage)->GetValueForKey("UserName", szTemp, sizeof(szTemp));
        pApp->SetUserName(szTemp);
        pApp->SetConnID(lConnID);
        pApp->AddRef(); 
        
        // Add to collection
        m_Applications.Add(hContext, pApp);
    }
    return pApp;
}

void CApplicationManager::DeleteApplication(SCARDCONTEXT hContext)
{
      CApplicationObject *pApp = (CApplicationObject *)m_Applications.Lookup(hContext);
      if(pApp != NULL)
      {
            long lRef = pApp->ReleaseRef(); 
            if (0 == lRef)
            {
                delete pApp;
                pApp = NULL;
                m_Applications.Remove(hContext);
            }
      }
}

