// DispatchMessageHandler.cpp: implementation of the CDispatchMessageHandler class. 
// 
////////////////////////////////////////////////////////////////////// 
 
#include "../../Include/Comm/DispatchMessageHandler.h" 
#include <memory.h> 
  
////////////////////////////////////////////////////////////////////// 
// Construction/Destruction 
////////////////////////////////////////////////////////////////////// 
 
CDispatchMessageHandler::CDispatchMessageHandler() : CThread ("DispatchMessageHandler","DispatchMessageHandler") 
{ 
	m_Message = NULL; 
	memset (m_szMessageNameHandled,0,sizeof(m_szMessageNameHandled)); 
	memset (m_szMessageTypeHandled,0,sizeof(m_szMessageTypeHandled)); 
} 
 
CDispatchMessageHandler::CDispatchMessageHandler(char *name) : CThread (name,"DispatchMessageHandler") 
{ 
	m_Message = NULL; 
	memset (m_szMessageNameHandled,0,sizeof(m_szMessageNameHandled)); 
	memset (m_szMessageTypeHandled,0,sizeof(m_szMessageTypeHandled)); 
} 
 
CDispatchMessageHandler::~CDispatchMessageHandler() 
{ 
 
} 
 
void CDispatchMessageHandler::SetMessage (CDispatchMessage* message) 
{ 
	m_Message = message; 
} 
 
CDispatchMessage *CDispatchMessageHandler::GetMessage (void) 
{ 
	return m_Message; 
} 
 
void CDispatchMessageHandler::SetMessageNameHandled (char *name) 
{ 
	if (name == NULL) 
	{ 
		return; 
	} 
 
	strncpy (m_szMessageNameHandled,name,sizeof(m_szMessageNameHandled)); 
} 
 
char *CDispatchMessageHandler::GetMessageNameHandled (void) 
{ 
	return m_szMessageNameHandled; 
} 
 
void CDispatchMessageHandler::SetMessageTypeHandled (char *type) 
{ 
	if (type == NULL) 
	{ 
		return; 
	} 
 
	strncpy (m_szMessageTypeHandled,type,sizeof(m_szMessageTypeHandled)); 
} 
 
char *CDispatchMessageHandler::GetMessageTypeHandled (void) 
{ 
	return m_szMessageTypeHandled; 
} 
 
void CDispatchMessageHandler::PreRun (void) 
{ 
	PreExecute(); 
} 
 
void CDispatchMessageHandler::Run (void) 
{ 
	Execute(); 
} 
 
void CDispatchMessageHandler::PostRun (void) 
{ 
	PostExecute(); 
} 
