// Connection.cpp: implementation of the CConnection class. 
// 
////////////////////////////////////////////////////////////////////// 
 
#include "../../Include/Comm/Connection.h" 
#include "../../Include/Comm/DispatchMessage.h" 
#include "../../Include/Base/LoggerManager.h" 
 
#include <string.h> 
  
////////////////////////////////////////////////////////////////////// 
// Construction/Destruction 
////////////////////////////////////////////////////////////////////// 
 
CConnection::CConnection() 
{ 
	m_szConnectionName = NULL; 
	m_szConnectionInfo = NULL; 
	m_bConnectionBreak = FALSE; 
	m_ulConnectionID = 0; 
} 
 
CConnection::CConnection(char *connectionType) : CThread (connectionType,"Connection") 
{ 
	m_szConnectionName = NULL; 
	m_szConnectionInfo = NULL; 
	m_bConnectionBreak = FALSE; 
	m_ulConnectionID = 0; 
} 
 
CConnection::~CConnection() 
{ 
	if (m_szConnectionName != NULL) delete m_szConnectionName; 
	if (m_szConnectionInfo != NULL) delete m_szConnectionInfo; 
} 
 
void CConnection::SetConnectionName (char *name) 
{ 
	if (name != NULL) 
	{ 
		if (m_szConnectionName != NULL) 
		{ 
			delete [] m_szConnectionName; 
		} 
 
		m_szConnectionName = new char [(strlen (name)) + 1]; 
		memset (m_szConnectionName,0,strlen(name)); 
		strncpy (m_szConnectionName,name,strlen(name)); 
	} 
} 
       
void CConnection::GetConnectionName (char *name,unsigned long length) 
{ 
	if (name != NULL && length != 0) 
	{ 
		if (m_szConnectionName == NULL) 
		{ 
			name[0] = '\0'; 
		} 
		else 
		{ 
			strncpy (name,m_szConnectionName,length); 
		} 
	} 
} 
 
void CConnection::SetConnectionID (unsigned long id) 
{ 
	m_ulConnectionID = id; 
} 
 
unsigned long CConnection::GetConnectionID (void) 
{ 
	return m_ulConnectionID; 
} 
 
void CConnection::SetConnectionInfo (char *info) 
{ 
	if (info != NULL) 
	{ 
		if (m_szConnectionInfo != NULL) 
		{ 
			delete [] m_szConnectionInfo; 
		} 
 
		m_szConnectionInfo = new char [(strlen (info)) + 1]; 
		memset (m_szConnectionInfo,0,strlen(info)); 
		strncpy (m_szConnectionInfo,info,strlen (info)); 
	} 
} 
 
void CConnection::GetconnectionInfo (char *info, unsigned long length) 
{ 
	if (info != NULL && length != 0) 
	{ 
		if (m_szConnectionInfo == NULL) 
		{ 
			info[0] = '\0'; 
		} 
		else 
		{ 
			strncpy (info,m_szConnectionInfo,length); 
		} 
	} 
} 
 
void CConnection::SetConnectionBreak (void) 
{ 
	Trace (__FILE__,__LINE__,LOGMASK_COMM,"Set m_bConnectionBreak flag"); 
 
	m_bConnectionBreak = TRUE; 
} 

BOOL CConnection::GetConnectionBreak (void)
{
	return m_bConnectionBreak;
}
 
unsigned long CConnection::SendAndGetBackMessage (CMessage *message) 
{ 
	// It's needs to be a DispatchMessage 
	if (message == NULL) 
	{ 
		return 0; 
	} 
 
	if (!(strcmp (message->GetName(),"DispatchMessage") == 0 && strcmp (message->GetType(),"Message") == 0)) 
	{ 
		// Not a DispatchMessage, return 0 
		return 0; 
	} 
 
	// Add '#DispatchKey#Routing#***ReturnBack***' and '#DispatchKey#Routing#***Sender***' 
	CDispatchMessage *pMessage = (CDispatchMessage *)message; 
 
	pMessage->AddValueForKey ("#DispatchKey#Routing#***ReturnBack***","Yes"); 
	pMessage->AddValueForKey ("#DispatchKey#Routing#***Sender***","Not supported"); 
 
	return SendMessage (message); 
} 
