    // StringToObjectCollection.cpp: implementation of the CStringToObjectCollection class.  
    //  
    //////////////////////////////////////////////////////////////////////  
      
  #include "../../Include/Base/StringToObjectCollection.h"  
  #include "../../Include/Base/StringContainer.h"  
  #include "../../Include/Base/ULongContainer.h"  
  #include "../../Include/Base/ByteContainer.h"  
  
  #include <string.h>  
      
    //////////////////////////////////////////////////////////////////////  
    // Construction/Destruction  
    //////////////////////////////////////////////////////////////////////  
      
    CStringToObjectCollection::CStringToObjectCollection() : CObject ("StringToObjectCollection","Collection")  
    {  
  	m_pPositionArray = (void **)new ULONG32 [101]; // 1 more for checking end of list  
  	memset (m_pPositionArray,0,101 * sizeof(ULONG32)); // Init position array  
    	m_ul32MaxObject = 100;  
    	m_ul32ObjectCount = 0;  
  	m_pCollectionBottom = NULL;  
  	m_pCollectionTop = NULL;  
    }  
      
    CStringToObjectCollection::~CStringToObjectCollection()  
    {  
    	delete m_pPositionArray;  
      
    	// Delete all elements  
      
  	__StringToObjectCollectionElement *element = NULL;  
  	__StringToObjectCollectionElement *elementTemp = NULL;  
      
    	if (m_pCollectionTop != NULL)  
    	{  
    		element = m_pCollectionTop;  
      
    		while (element != NULL)  
    		{  
  			// Delete key  
  			if (element->key != NULL)  
  			{  
  				delete element->key;  
  			}  
    			elementTemp = element->next;  
    			delete element;  
    			element = elementTemp;  
    		}  
    	}  
    }  
      
    void CStringToObjectCollection::Add (char *key, CObject *object)  
    {        
    	BOOL foundKey = FALSE;  
      
    	// First check if the key already exist  
      
  	__StringToObjectCollectionElement *elementCheck = NULL;  
      
    	if (m_pCollectionTop != NULL)  
    	{  
    		elementCheck = m_pCollectionTop;  
      
    		while (foundKey == FALSE && elementCheck != NULL)  
    		{  
    			if (elementCheck->key != NULL)  
    			{  
    				if (strcmp (elementCheck->key,key) == 0)  
    				{  
    					// Found double  
    					foundKey = TRUE;  
    				}  
    				else  
    				{  
    					elementCheck = elementCheck->next;  
    				}  
    			} 
    		}  
      
    	}  
      
    	if (foundKey == TRUE)  
    	{  
            delete elementCheck->object; 
    		// Overwrite previous Object Reference  
    		elementCheck->object = object;  
    	}  
    	else  
    	{  
    		// New object to collection  
      
    		__StringToObjectCollectionElement *tempElement = new __StringToObjectCollectionElement;  
    		tempElement->object = object;  
    		tempElement->next = NULL;  
      
    		if (m_pCollectionTop == NULL)  
    		{  
    			m_pCollectionBottom = tempElement;  
    			m_pCollectionTop = tempElement;  
    		}  
    		else  
    		{  
    			m_pCollectionBottom->next = tempElement;  
    			m_pCollectionBottom = tempElement;  
    		}  
      
    		// Copy key  
      
    		int keyLength = strlen (key);  
    		  
    		char *tempKey = new char [keyLength + 1];  
    		strcpy (tempKey,key);  
      
    		tempElement->key = tempKey;  
      
    		// Set position  
      
    		tempElement->position = m_ul32ObjectCount;  
      
    		// Set element pointer in position array  
      
    		if (m_ul32ObjectCount >= m_ul32MaxObject)  
    		{  
    			// Expand position array  
    			m_ul32MaxObject += 100;  
  			void **tempPositionArray = (void **) new ULONG32[(m_ul32MaxObject + 1)*sizeof(ULONG32)];  
  			memset (tempPositionArray,0,(m_ul32MaxObject + 1)*sizeof(ULONG32));  
    			memcpy (tempPositionArray,m_pPositionArray,(m_ul32MaxObject - 100)*sizeof(ULONG32));  
    			delete m_pPositionArray;  
    			m_pPositionArray = tempPositionArray;  
    		}  
      
    		m_pPositionArray[m_ul32ObjectCount] = tempElement;  
      
    		m_ul32ObjectCount++;  
    	}	  
    }  
      
    ULONG32 CStringToObjectCollection::GetCount (void)  
    {  
    	return m_ul32ObjectCount;  
    }  
      
    BOOL CStringToObjectCollection::IsEmpty (void)  
    {  
    	if (m_ul32ObjectCount == 0)  
    	{  
    		return FALSE;  
    	}  
      
    	return TRUE;  
    }  
      
    CObject *CStringToObjectCollection::Lookup (char *key)  
    {  
    	BOOL foundKey = FALSE;  
      
    	// Search the key  
      
  	__StringToObjectCollectionElement *elementCheck = NULL;  
      
    	if (m_pCollectionTop != NULL)  
    	{  
    		elementCheck = m_pCollectionTop;  
      
    		while (foundKey == FALSE && elementCheck != NULL)  
    		{  
    			if (elementCheck->key != NULL)  
    			{  
    				if (strcmp (elementCheck->key,key) == 0)  
    				{  
    					// Found double  
    					foundKey = TRUE;  
    				}  
    				else  
    				{  
    					elementCheck = elementCheck->next;  
    				}  
    			} 
                else
                {
    					elementCheck = elementCheck->next;  
                }                
    		}  
      
    	}  
      
    	if (foundKey == TRUE)  
    	{  
    		return elementCheck->object;  
    	}  
      
  	return NULL;  
    }  
      
    CObject *CStringToObjectCollection::GetFirst (  
    	ULONG32 *firstPosition,  
    	char *key,  
    	unsigned long keyLength)  
    {  
    	__StringToObjectCollectionElement *element = NULL;  
      
    	if (firstPosition == NULL || key == NULL || keyLength == 0)  
    	{  
    		return NULL;  
    	}  
      
    	if (m_ul32ObjectCount == 0)  
    	{  
    		*firstPosition = 0;  
    		return NULL;  
    	}  
      
    	if (m_pPositionArray[0] == 0)  
    	{  
    		*firstPosition = 0;  
    		return NULL;  
    	}  
      
    	element = (__StringToObjectCollectionElement *)m_pPositionArray[0];  
    	*firstPosition = 1;  
    	if (element->key == NULL)  
    	{  
    		key[0] = '\0';  
    	}  
    	else  
    	{  
    		strncpy (key,element->key,keyLength);  
    	}  
      
    	return element->object;  
    }  
      
    CObject *CStringToObjectCollection::GetNext (  
    	ULONG32 *nextPosition,  
    	char *key,  
    	unsigned long keyLength)  
    {  
    	__StringToObjectCollectionElement *element = NULL;  
      
    	if (nextPosition == NULL || key == NULL || keyLength == 0)  
    	{   
    		return NULL;  
    	}  
      
    	if (m_ul32ObjectCount == 0)  
    	{  
    		*nextPosition = 0;  
    		return NULL;  
    	}  
      
    	if (m_pPositionArray[*nextPosition] == 0)  
    	{  
    		*nextPosition = 0;  
    		return NULL;  
    	}  
      
    	element = (__StringToObjectCollectionElement *)m_pPositionArray[*nextPosition];  
    	*nextPosition = *nextPosition + 1;  
    	if (element->key == NULL)  
    	{  
    		key[0] = '\0';  
    	}  
    	else  
    	{  
    		strncpy (key,element->key,keyLength);  
    	}  
      
    	return element->object;  
    }  
      
    BOOL CStringToObjectCollection::Remove (char *key)  
    {  
    	if (key == NULL)  
    	{  
    		return FALSE;  
    	}  
      
    	// Find the key  
    	BOOL foundKey = FALSE;  
      
    	__StringToObjectCollectionElement *elementCheck = NULL;  
    	__StringToObjectCollectionElement *previous = NULL;  
      
    	if (m_pCollectionTop != NULL)  
    	{  
    		elementCheck = m_pCollectionTop;  
      
    		while (foundKey == FALSE && elementCheck != NULL)  
    		{  
    			if (elementCheck->key != NULL)  
    			{  
    				if (strcmp (elementCheck->key,key) == 0)  
    				{  
    					// Found double  
    					foundKey = TRUE;  
    				}  
    				else  
    				{  
    					previous = elementCheck;  
    					elementCheck = elementCheck->next;  
    				}  
    			}  
    		}  
    	}  
      
    	if (foundKey == FALSE)  
    	{  
    		// Key not found return FALSE  
    		return FALSE;  
    	}  
      
    	// Key found, now get its position and remove it from the list  
    	if (previous == NULL && elementCheck->next == NULL)  
    	{  
    		// This was the only record in the list  
    		// Empty the collection  
    		m_pCollectionBottom = NULL;  
    		m_pCollectionTop = NULL;  
      
    		// Reset object count  
    		m_ul32ObjectCount = 0;  
      
    		// Clean position array  
    		memset (m_pPositionArray,0,m_ul32MaxObject);  
      
    		delete elementCheck->key;  
    		delete elementCheck;  
    	}  
    	else if (previous == NULL && elementCheck->next != NULL)	  
    	{  
    		// the key was the first in the list  
    		// Set new Collection Top  
    		m_pCollectionTop = elementCheck->next;  
    	  
    		// Update position array and change position in record  
      
    		m_ul32ObjectCount--;  
      
    		unsigned long counter = 0;  
    		__StringToObjectCollectionElement *element = m_pCollectionTop;  
      
    		// Clean up position array before re-numbering  
    		memset (m_pPositionArray,0,m_ul32MaxObject);  
      
    		while (element != NULL)  
    		{  
    			m_pPositionArray[counter] = element;  
    			element->position = counter;  
      
    			counter++;  
    			element = element->next;  
    		}  
      
    		delete elementCheck->key;  
    		delete elementCheck;  
    	}  
    	else if (previous != NULL && elementCheck->next == NULL)  
    	{  
    		// Last record  
      
    		// Set collection bottom  
    		m_pCollectionBottom = previous;  
    		previous->next = NULL;  
      
    		// Update object count  
    		m_ul32ObjectCount--;  
      
    		// Set position array to 0  
    		m_pPositionArray[elementCheck->position] = 0;  
      
    		// delete element  
    		delete elementCheck->key;  
    		delete elementCheck;  
    	}  
    	else if (previous != NULL && elementCheck->next != NULL)  
    	{  
    		// somewhere in the list  
      
    		// Link previous with next record  
    		previous->next = elementCheck->next;  
      
    		// Update position array and change position in record  
      
    		m_ul32ObjectCount--;  
      
    		unsigned long counter = previous->position + 1;  
    		__StringToObjectCollectionElement *element = elementCheck->next;  
      
    		// Clean up position array after previous record  
    		memset (m_pPositionArray + previous->position + 1,0,(m_ul32MaxObject - previous->position) + 1);  
      
    		while (element != NULL)  
    		{  
    			m_pPositionArray[counter] = element;  
    			element->position = counter;  
      
    			counter++;  
    			element = element->next;  
    		}  
      
    		delete elementCheck->key;  
    		delete elementCheck;  
    	}  
      
    	return TRUE;  
    }  
      
    BOOL CStringToObjectCollection::Remove (CObject *object)  
    {  
    	if (object == NULL)  
    	{  
    		return FALSE;  
    	}  
      
    	// Find the key  
    	BOOL foundKey = FALSE;  
      
    	__StringToObjectCollectionElement *elementCheck = NULL;  
    	__StringToObjectCollectionElement *previous = NULL;  
      
    	if (m_pCollectionTop != NULL)  
    	{  
    		elementCheck = m_pCollectionTop;  
      
    		while (foundKey == FALSE && elementCheck != NULL)  
    		{  
    			if (elementCheck->object != NULL)  
    			{  
    				if (elementCheck->object == object)  
    				{  
    					// Found double  
    					foundKey = TRUE;  
    				}  
    				else  
    				{  
    					previous = elementCheck;  
    					elementCheck = elementCheck->next;  
    				}  
    			}  
    		}  
    	}  
      
    	if (foundKey == FALSE)  
    	{  
    		// Key not found return FALSE  
    		return FALSE;  
    	}  
      
    	// Key found, now get its position and remove it from the list  
    	if (previous == NULL && elementCheck->next == NULL)  
    	{  
    		// This was the only record in the list  
    		// Empty the collection  
    		m_pCollectionBottom = NULL;  
    		m_pCollectionTop = NULL;  
      
    		// Reset object count  
    		m_ul32ObjectCount = 0;  
      
    		// Clean position array  
    		memset (m_pPositionArray,0,m_ul32MaxObject);  
      
    		delete elementCheck->key;  
    		delete elementCheck;  
    	}  
    	else if (previous == NULL && elementCheck->next != NULL)	  
    	{  
    		// the key was the first in the list  
    		// Set new Collection Top  
    		m_pCollectionTop = elementCheck->next;  
    	  
    		// Update position array and change position in record  
      
    		m_ul32ObjectCount--;  
      
    		unsigned long counter = 0;  
    		__StringToObjectCollectionElement *element = m_pCollectionTop;  
      
    		// Clean up position array before re-numbering  
    		memset (m_pPositionArray,0,m_ul32MaxObject);  
      
    		while (element != NULL)  
    		{  
    			m_pPositionArray[counter] = element;  
    			element->position = counter;  
      
    			counter++;  
    			element = element->next;  
    		}  
      
    		delete elementCheck->key;  
    		delete elementCheck;  
    	}  
    	else if (previous != NULL && elementCheck->next == NULL)  
    	{  
    		// Last record  
      
    		// Set collection bottom  
    		m_pCollectionBottom = previous;  
    		previous->next = NULL;  
      
    		// Update object count  
    		m_ul32ObjectCount--;  
      
    		// Set position array to 0  
    		m_pPositionArray[elementCheck->position] = 0;  
      
    		// delete element  
    		delete elementCheck->key;  
    		delete elementCheck;  
    	}  
    	else if (previous != NULL && elementCheck->next != NULL)  
    	{  
    		// somewhere in the list  
      
    		// Link previous with next record  
    		previous->next = elementCheck->next;  
      
    		// Update position array and change position in record  
      
    		m_ul32ObjectCount--;  
      
    		unsigned long counter = previous->position + 1;  
    		__StringToObjectCollectionElement *element = elementCheck->next;  
      
    		// Clean up position array after previous record  
    		memset (m_pPositionArray + previous->position + 1,0,(m_ul32MaxObject - previous->position) + 1);  
      
    		while (element != NULL)  
    		{  
    			m_pPositionArray[counter] = element;  
    			element->position = counter;  
      
    			counter++;  
    			element = element->next;  
    		}  
      
    		delete elementCheck->key;  
    		delete elementCheck;  
    	}  
      
    	return TRUE;  
    }  
      
    BOOL CStringToObjectCollection::RemoveAll (void)  
    {  
    	// delete all keys and structure  
    	__StringToObjectCollectionElement *elementCheck = NULL;  
      
    	if (m_pCollectionTop != NULL)  
    	{  
    		elementCheck = m_pCollectionTop;  
      
    		while (elementCheck != NULL)  
    		{  
    			if (elementCheck->key != NULL)  
    			{  
    				delete elementCheck->key;  
    			}  
    			__StringToObjectCollectionElement *tmp = elementCheck;  
    			elementCheck = elementCheck->next;  
    			delete tmp;  
    		}  
    	}  
      
    	// Clean up position array  
    	memset (m_pPositionArray,0,m_ul32MaxObject);  
      
    	// Reset object count  
    	m_ul32ObjectCount = 0;  
      
    	// close list  
    	m_pCollectionTop = NULL;  
    	m_pCollectionBottom = NULL;  
      
    	return TRUE;  
    }  
      
    BOOL CStringToObjectCollection::Serialize (void)  
    {  
    	CObject::Serialize ();  
      
    	ULONG32 position = 0;  
    	CObject *object = NULL;  
    	char key[256];  
      
    	// Serialize object count   
    	  
    	AddULongToSerialObject (GetCount(),serializedObject);  
      
    	object = GetFirst (&position,key,256);  
      
    	while (object != NULL)  
    	{  
    		// Serialize object  
      
    		// Check if it's a container  
    		if (strcmp (object->GetType(),"Container") == 0)  
    		{  
    			// Check it's name  
    			if (strcmp (object->GetName(),"StringContainer") == 0)  
    			{  
    				// Set container flag in serialized object  
    				AddULongToSerialObject (1,serializedObject);  
    				// Serialize string  
    				AddCharToSerialObject (key,serializedObject);  
    				AddCharToSerialObject (((CStringContainer *)object)->GetString(),  
    					serializedObject);  
    			}  
    			else if (strcmp (object->GetName(),"ULongContainer") == 0)  
    			{  
    				// Set container flag in serialized object  
    				AddULongToSerialObject (2,serializedObject);  
    				// Serialize unsigned long  
    				AddCharToSerialObject (key,serializedObject);  
    				AddULongToSerialObject (((CLongContainer *)object)->GetULong(),  
    					serializedObject);  
    			}  
    			else if (strcmp (object->GetName(),"ByteContainer") == 0)  
    			{  
    				unsigned long bufferLength = ((CByteContainer *)object)->GetLength();  
    				BYTE *buffer = new BYTE[bufferLength];  
    				((CByteContainer *)object)->GetBytes (buffer,bufferLength);  
      
    				// Set container flag in serialized object  
    				AddULongToSerialObject (3,serializedObject);  
    				// Serialize bytes  
    				AddCharToSerialObject (key,serializedObject);  
    				AddBytesToSerialObject (buffer,bufferLength,serializedObject);  
      
    				delete buffer;  
    			}  
    			else  
    			{  
    				// Set container flag to 0  
    				AddULongToSerialObject (0,serializedObject);  
    			}  
    		}  
    		else  
    		{  
    			AddULongToSerialObject (0,serializedObject);  
    		}  
      
    		object = GetNext (&position,key,256);  
    	}  
      
    	return TRUE;  
    }  
      
    BOOL CStringToObjectCollection::UnSerialize (struct SerializedObject* anObject)  
    {  
    	CObject::UnSerialize (anObject);  
      
    	char *key;  
      
    	// Get number of object  
    	ULONG32 objectCount = GetULongFromSerialObject (serializedObject);  
    	ULONG32 i;  
      
    	for (i=0;i<objectCount;i++)  
    	{  
    		// Get container ID  
    		unsigned long containerID = GetULongFromSerialObject (serializedObject);  

			if (containerID == 0)
			{
				// Wrong value, return FALSE
				return FALSE;
			}

    		// Get key  
    		key = GetCharFromSerialObject (serializedObject);  

			if (key == NULL)
			{
				// Can't get key, return FALSE
				return FALSE;
			}

    		if (containerID == 1)  
    		{  
    			CStringContainer *container = new CStringContainer;  
    			char *stringTemp = GetCharFromSerialObject (serializedObject);  
    			container->SetString (stringTemp);  
    			// Add object to values collection  
    			Add (key,container);  
    			delete stringTemp;  
    		}  
    		else if (containerID == 2)  
    		{  
    			CLongContainer *container = new CLongContainer;  
    			unsigned long ULongTemp = GetULongFromSerialObject (serializedObject);  
    			container->SetULong (ULongTemp);  
    			// Add object to values collection  
    			Add (key,container);  
    		}  
    		else if (containerID == 3)  
    		{  
    			CByteContainer *container = new CByteContainer;  
    			BYTE *byte;  
    			unsigned long byteLength = GetBytesFromSerialObject (&byte,serializedObject);  
    			container->SetBytes (byte,byteLength);  
    			// Add object to values collection  
    			Add (key,container);  
    			delete byte;  
    		}  
      
    		// Delete key  
    		delete key;  
    	}  
      
    	return TRUE;  
    } 
 
