        // Object.cpp: implementation of the CObject class. 
        // 
        ////////////////////////////////////////////////////////////////////// 
 
#ifdef _WIN32         
#include <stddef.h> 
#include <string.h> 
#include <stdarg.h> 
#endif // _WIN32 
 
#ifdef linux 
#include <stdio.h> 
#include <string.h> 
#include <stdarg.h> 
#include <stdlib.h>
#include <netinet/in.h>
#endif // linux 
 
#ifdef __SCO__ 
#include <stddef.h> 
#include <string.h> 
#include <stdarg.h>
#include <sys/byteorder.h>
#endif // __SCO__ 
 
#ifdef __HPUX__ 
#include <stddef.h> 
#include <stdio.h>
#include <string.h> 
#include <stdarg.h>
#endif // __HPUX__ 
 
#ifdef __BEOS__
#include <stdio.h> 
#include <string.h> 
#include <stdarg.h> 
#include <stdlib.h>
#include <ByteOrder.h> 
#endif // __BEOS__
 
#include "../../Include/Base/Object.h" 
 
#include "../../Include/Base/MasterManager.h" 
#include "../../Include/Base/LoggerManager.h" 
  
//////////////////////////////////////////////////////////////////////  
// Construction/Destruction  
//////////////////////////////////////////////////////////////////////  
  
CObject::CObject()  
{  
	Init(); 
}  
          
CObject::CObject(char *name, char *type)  
{  
	Init(); 

	SetName (name);  
	SetType (type);  
}  

CObject::CObject(char *name)  
{  
	Init(); 

	SetName (name);  
	SetType ("Object");  
}  
 
void CObject::Init (void) 
{ 
	serializedObject = NULL;  
	m_bCanBeDeleted = FALSE;  
	m_sName = NULL;  
	m_sType = NULL;  
	m_bSerialMultiPass = FALSE;  
	m_bSerialMultiPassCount = FALSE;  
	m_bSerialMultiPassFill = FALSE;  
	m_bSerialMultiPassFillOffset = 0;  
	m_bSerialMultiPassObjectAllocated = FALSE;  
	m_szDescriptionBuffer = NULL; 
	m_Logger = NULL; 
} 

CObject::~CObject()  
{  
	if (serializedObject != NULL)  
	{  
		if (serializedObject->name != NULL)  
		{  
			delete serializedObject->name; 
		}  
		if (serializedObject->type != NULL)  
		{  
			delete serializedObject->type;  
		}  
		if (serializedObject->serializedObject != NULL)  
		{  
			delete serializedObject->serializedObject;  
		}  
		delete serializedObject;  
	}  
	if (m_sName != NULL)  
	{  
		delete m_sName;  
	}  
	if (m_sType != NULL)  
	{  
		delete m_sType;  
	}
    if(m_szDescriptionBuffer != NULL)
    {
        delete m_szDescriptionBuffer;
    }
}  
  
char *CObject::GetName (void)  
{  
	return m_sName;  
}  
  
void CObject::SetName (char *name)  
{  
	if (name != NULL)  
	{  
		if (m_sName != NULL)  
		{  
			delete m_sName;  
		}  
		m_sName = new char [(strlen (name)) + 1];  
		strcpy (m_sName,name);  
	}  
}  
  
char *CObject::GetType (void)  
{  
	return m_sType;  
}  
  
void CObject::SetType (char *type)  
{  
	if (type != NULL)  
	{  
		if (m_sType != NULL)  
		{  
			delete m_sType;  
		}  
		m_sType = new char [(strlen (type)) + 1];  
		strcpy (m_sType,type);  
	}  
}  
          
CObject* CObject::Clone (void)  
{  
	return NULL;  
}  
  
CObject* CObject::Copy (void)  
{  
	return NULL;  
}  
  
BOOL CObject::Serialize (void)  
{  
	// already exist an old serialized object ?  
  
	if (m_bSerialMultiPass == FALSE)  
	{  
		if (serializedObject != NULL)  
		{  
			if (serializedObject->name != NULL)  
			{  
				delete serializedObject->name;  
			}  
			if (serializedObject->type != NULL)  
			{  
				delete serializedObject->type;  
			}  
			if (serializedObject->serializedObject != NULL)
			{  
				delete serializedObject->serializedObject;
			}
			delete serializedObject;
			serializedObject = NULL; 
		}  
		// Allocate a new serialized object  
  
		serializedObject = new SerializedObject;  
  
		// Set Name and Type  
  
		if (m_sName == NULL)  
		{  
			serializedObject->name = NULL;  
			serializedObject->nameSize = 0;  
		}  
		else  
		{  
			serializedObject->nameSize = strlen (m_sName);  
			serializedObject->name = new char [serializedObject->nameSize];  
			memcpy (serializedObject->name, m_sName, serializedObject->nameSize);  
		}  
  
		if (m_sType == NULL)  
		{  
			serializedObject->type = NULL;  
			serializedObject->typeSize = 0;  
		}  
		else  
		{  
			serializedObject->typeSize = strlen (m_sType);  
			serializedObject->type = new char [serializedObject->typeSize];  
			memcpy (serializedObject->type, m_sType, serializedObject->typeSize);  
		}  
  
		serializedObject->serializedObjectSize = 0;  
		serializedObject->serializedObject = NULL;  
	}  
	else if (m_bSerialMultiPass == TRUE && m_bSerialMultiPassObjectAllocated == FALSE)
	{  
		if (serializedObject != NULL)  
		{  
			if (serializedObject->name != NULL)  
			{  
				delete serializedObject->name;  
			}  
			if (serializedObject->type != NULL)  
			{  
				delete serializedObject->type;  
			}  
			if (serializedObject->serializedObject != NULL)  
			{  
				delete serializedObject->serializedObject;  
			}  
			delete serializedObject;  
			serializedObject = NULL;  
		}  
  
		m_bSerialMultiPassObjectAllocated = TRUE;  
  
		// Allocate a new serialized object  
  
		serializedObject = new SerializedObject;  
  
		// Set Name and Type  
  
		if (m_sName == NULL)  
		{  
			serializedObject->name = NULL;  
			serializedObject->nameSize = 0;  
		}  
		else  
		{  
			serializedObject->nameSize = strlen (m_sName);  
			serializedObject->name = new char [serializedObject->nameSize];  
			memcpy (serializedObject->name, m_sName, serializedObject->nameSize);  
		}  
  
		if (m_sType == NULL)  
		{  
			serializedObject->type = NULL;  
			serializedObject->typeSize = 0;  
		}  
		else  
		{  
			serializedObject->typeSize = strlen (m_sType);  
			serializedObject->type = new char [serializedObject->typeSize];  
			memcpy (serializedObject->type, m_sType, serializedObject->typeSize);  
		}  
  
		serializedObject->serializedObjectSize = 0;  
		serializedObject->serializedObject = NULL;  
	}  
  
	AddULongToSerialObject (ID,serializedObject);  
	AddCharToSerialObject (m_sName,serializedObject);  
	AddCharToSerialObject (m_sType,serializedObject);  
  
	return TRUE;  
}  
  
struct SerializedObject* CObject::GetSerializedObject (void)  
{  
	return serializedObject;  
}  
  
void CObject::SetID (unsigned long anID)  
{  
	ID = anID;  
}  
  
BOOL CObject::UnSerialize (struct SerializedObject* anObject)  
{  
	// Make a local copy first  
  
	// already exist an old serialized object ?  
  
	if (serializedObject != NULL)  
	{  
		if (serializedObject->name != NULL)  
		{  
			delete serializedObject->name;  
		}  
		if (serializedObject->type != NULL)  
		{  
			delete serializedObject->type;  
		}  
		if (serializedObject->serializedObject != NULL)  
		{  
			delete serializedObject->serializedObject;  
		}  
		delete serializedObject;  
		serializedObject = NULL;  
	}  
  
	// Allocate a new serialized object  
  
	serializedObject = new SerializedObject;  
	serializedObject->nameSize = anObject->nameSize;  
	if (anObject->nameSize == 0)  
	{  
		serializedObject->name = NULL;  
	}  
	else  
	{  
		// Alloc name  
		serializedObject->name = new char[anObject->nameSize];  
		strncpy (serializedObject->name,anObject->name,anObject->nameSize);  
	}  
  
	serializedObject->typeSize = anObject->typeSize;  
	if (anObject->typeSize == 0)  
	{  
		serializedObject->type = NULL;  
	}  
	else  
	{  
		// Alloc type  
		serializedObject->type = new char[anObject->typeSize];  
		strncpy (serializedObject->type,anObject->type,anObject->typeSize);  
	}  
  
	serializedObject->serializedObjectSize = anObject->serializedObjectSize;  
	if (anObject->serializedObjectSize == 0)  
	{  
		serializedObject->serializedObject = NULL;  
	}  
	else  
	{  
		// Alloc object  
		serializedObject->serializedObject = new BYTE[anObject->serializedObjectSize];  
		memcpy (serializedObject->serializedObject,anObject->serializedObject,anObject->serializedObjectSize);  
	}  
	ID = 0;
	ID = GetULongFromSerialObject (serializedObject);  

	if (m_sName != NULL) 
	{ 
		delete m_sName; 
	} 
	m_sName = GetCharFromSerialObject (serializedObject);  

	if (m_sType != NULL) 
	{ 
		delete m_sType; 
	} 
	m_sType = GetCharFromSerialObject (serializedObject);  
	return TRUE;  
}  
  
unsigned long CObject::GetID (void)  
{  
	return ID;  
}  
  
BOOL CObject::CanBeDeleted (void)  
{  
	return m_bCanBeDeleted;  
}  
  
void CObject::Release (void)  
{  
	m_bCanBeDeleted = TRUE;  
}  
          
void CObject::SetSerialMultiPass (void)  
{  
	m_bSerialMultiPass = TRUE;  
	m_bSerialMultiPassFillOffset = 0;  
}  
  
void CObject::SetSerialMultiPassCount (void)  
{  
	m_bSerialMultiPassCount = TRUE;  
}  
  
void CObject::SetSerialMultiPassFill (void)  
{  
	m_bSerialMultiPassCount = FALSE;  
	m_bSerialMultiPassFill = TRUE;  
	m_bSerialMultiPassFillOffset = 0;  
	// Allocate serial object buffer  
	if (serializedObject->serializedObject != NULL)
	{
		delete serializedObject->serializedObject;
	}

	serializedObject->serializedObject = new BYTE [serializedObject->serializedObjectSize];  
}  
          
void CObject::ResetSerialMultiPass (void)  
{  
	m_bSerialMultiPass = FALSE;  
	m_bSerialMultiPassCount = FALSE;  
	m_bSerialMultiPassFill = FALSE;  
	m_bSerialMultiPassFillOffset = 0;  
	m_bSerialMultiPassObjectAllocated = FALSE;  
}  
          
BOOL CObject::AddULongToSerialObject (unsigned long value,SerializedObject *anObject)  
{  
	if (m_bSerialMultiPass == FALSE)  
	{  
		unsigned long valueSize = 4;  
		unsigned long oldObjectSize = anObject->serializedObjectSize;  
  
		BYTE *buffer = new BYTE [oldObjectSize + valueSize + 4];  
		memcpy (buffer + oldObjectSize,&valueSize,4);  

		value = htonl (value);

		memcpy (buffer + oldObjectSize + 4, &value, valueSize);  
  
		if (oldObjectSize != 0)  
		{  
			memcpy (buffer, anObject->serializedObject, oldObjectSize);  
  
			delete anObject->serializedObject;  
		}  
  
		anObject->serializedObject = buffer;  
		anObject->serializedObjectSize = 4 + valueSize + oldObjectSize;  
	}  
	else  
	{  
		// Serial Multipass ON  
		if (m_bSerialMultiPassCount == TRUE)  
		{  
			// Calculate the serial object size  
			anObject->serializedObjectSize += 8; // valueSize = 4 and value = 4  
		}  
		else if (m_bSerialMultiPassFill == TRUE)  
		{  
			// Fill the serial object  
			unsigned long valueSize = 4;  
  
			memcpy (anObject->serializedObject + m_bSerialMultiPassFillOffset,   
				&valueSize, 4);  
			m_bSerialMultiPassFillOffset += 4;  
			
			value = htonl (value);

			memcpy (anObject->serializedObject + m_bSerialMultiPassFillOffset,   
				&value, 4);  
			m_bSerialMultiPassFillOffset += 4;  
		}  
	}  
  
	return TRUE;  
}  
          
BOOL CObject::AddCharToSerialObject (char *value,SerializedObject *anObject)  
{  
	if (m_bSerialMultiPass == FALSE)  
	{  
		unsigned long valueSize;
		  
		if (value == NULL)  
		{  
			valueSize = 0;  
		}  
		else  
		{  
			valueSize = strlen (value);  
		}  
  
		unsigned long valueNetOrder = htonl (valueSize);
		unsigned long oldObjectSize = anObject->serializedObjectSize;  
  
		BYTE *buffer = new BYTE [oldObjectSize + valueSize + 4];  
		memcpy (buffer + oldObjectSize ,&valueNetOrder,4);  
  
		if (valueSize != 0)  
		{  
			memcpy (buffer + 4 + oldObjectSize, value, valueSize);  
		}  
  
		if (oldObjectSize != 0)  
		{  
			memcpy (buffer, anObject->serializedObject, oldObjectSize);  
  
			delete anObject->serializedObject;  
		}  
  
		anObject->serializedObject = buffer;  
		anObject->serializedObjectSize = 4 + valueSize + oldObjectSize;  
	}  
	else  
	{  
		// Serial Multipass ON  
		if (m_bSerialMultiPassCount == TRUE)  
		{  
			// Calculate the serial object size  
			unsigned long valueSize; 
			  
			if (value == NULL)  
			{  
				valueSize = 0;  
			}  
			else  
			{  
				valueSize = strlen (value);  
			}  
			  
			valueSize += 4;  
  
			anObject->serializedObjectSize += valueSize;  
		}  
		else if (m_bSerialMultiPassFill == TRUE)  
		{  
			// Fill the serial object  
			unsigned long valueSize = 4;  
  
			if (value == NULL)  
			{  
				valueSize = 0;  
			}  
			else  
			{  
				valueSize = strlen (value);  
			}  
  
			unsigned long valueNetOrder = htonl (valueSize);

			memcpy (anObject->serializedObject + m_bSerialMultiPassFillOffset,   
				&valueNetOrder, 4);  
			m_bSerialMultiPassFillOffset += 4;  
  
			if (valueSize != 0)  
			{  
				memcpy (anObject->serializedObject + m_bSerialMultiPassFillOffset,   
					value, valueSize);  
				m_bSerialMultiPassFillOffset += valueSize;  
			}  
		}  
	}  
	return TRUE;  
}  
          
BOOL CObject::AddBytesToSerialObject (BYTE *value,unsigned long size,SerializedObject *anObject)  
{  
	if (m_bSerialMultiPass == FALSE)  
	{  
		unsigned long valueSize;  
		  
		if (value == NULL)  
		{  
			valueSize = 0;  
		}  
		else  
		{  
			valueSize = size;  
		}  

		unsigned long valueNetOrder = htonl (valueSize);

		unsigned long oldObjectSize = anObject->serializedObjectSize;  
  
		BYTE *buffer = new BYTE [oldObjectSize + valueSize + 4];  
		memcpy (buffer + oldObjectSize ,&valueNetOrder,4);  
  
		if (valueSize != 0)  
		{  
			memcpy (buffer + 4 + oldObjectSize, value, valueSize);  
		}  
  
		if (oldObjectSize != 0)  
		{  
			memcpy (buffer, anObject->serializedObject, oldObjectSize);  
  
			delete anObject->serializedObject;  
		}  
  
		anObject->serializedObject = buffer;  
		anObject->serializedObjectSize = 4 + valueSize + oldObjectSize;  
	}  
	else  
	{  
		// Serial Multipass ON  
		if (m_bSerialMultiPassCount == TRUE)  
		{  
			// Calculate the serial object size  
			unsigned long valueSize;  
			  
			if (value == NULL)  
			{  
				valueSize = 0;  
			}  
			else  
			{  
				valueSize = size;  
			}  
			  
			valueSize += 4;  
  
			anObject->serializedObjectSize += valueSize;  
		}  
		else if (m_bSerialMultiPassFill == TRUE)  
		{  
			// Fill the serial object  
			unsigned long valueSize;  
  
			if (value == NULL)  
			{  
				valueSize = 0;  
			}  
			else  
			{  
				valueSize = size;  
			}  

			unsigned long valueNetOrder = htonl (valueSize);

			memcpy (anObject->serializedObject + m_bSerialMultiPassFillOffset,   
				&valueNetOrder, 4);  
			m_bSerialMultiPassFillOffset += 4;  
  
			if (valueSize != 0)  
			{  
				memcpy (anObject->serializedObject + m_bSerialMultiPassFillOffset,   
					value, valueSize);  
				m_bSerialMultiPassFillOffset += valueSize;  
			}  
		}  
	}  
  
	return TRUE;  
}  
          
unsigned long CObject::GetULongFromSerialObject (SerializedObject *anObject)  
{  
	unsigned long valuePtr = 0;  
  
	if (m_bSerialMultiPass == FALSE)  
	{  
		if (anObject->serializedObject != NULL)  
		{  
  
			memcpy (&valuePtr, anObject->serializedObject + 4, 4);  

			valuePtr = ntohl (valuePtr);
  
			// Now strip down the serialized object  
  
			unsigned long newObjectSize = anObject->serializedObjectSize - 4 - 4;  
  
			if (newObjectSize == 0)  
			{  
				anObject->serializedObject = NULL;  
				anObject->serializedObjectSize = 0;  
			}  
			else  
			{  
				BYTE *buffer = new BYTE [newObjectSize];
				
				if (buffer == NULL)
				{
					// Can't allocate buffer, return 0
					return 0;
				}
  
				memcpy (buffer,anObject->serializedObject + 4 + 4, newObjectSize);  
  
				delete anObject->serializedObject;  
				anObject->serializedObject = buffer;  
				anObject->serializedObjectSize = newObjectSize;  
			}  
		}  
		else  
		{  
			valuePtr = 0;  
		}  
	}  
	else  
	{  
		if (anObject->serializedObject != NULL)  
		{  
  
			memcpy (&valuePtr, anObject->serializedObject +  
				m_bSerialMultiPassFillOffset + 4, 4);  

			valuePtr = ntohl (valuePtr);
  
			// Now strip down the serialized object  
  
			m_bSerialMultiPassFillOffset += 8;  
		}  
		else  
		{  
			valuePtr = 0;  
		}  
	}  
  
	return valuePtr;  
}  
          
char *CObject::GetCharFromSerialObject (SerializedObject *anObject)  
{  
	unsigned long valueSize = 0;  
  
	char *valuePtr = NULL;  
  
	if (m_bSerialMultiPass == FALSE)  
	{  
		if (anObject->serializedObject != NULL)  
		{  
			memcpy (&valueSize, anObject->serializedObject, 4);  

			valueSize = ntohl (valueSize);
  
			if (valueSize == 0)  
			{  
			// Set string empty  
			valuePtr = new char [1];  
			valuePtr[0] = '\0';  
			}  
			else  
			{  
				valuePtr = new char [valueSize + 1];  

				if (valuePtr == NULL)
				{
					// Can't allocate buffer, return NULL
					return NULL;
				}

				memcpy (valuePtr, anObject->serializedObject + 4, valueSize);  
				memset (valuePtr + valueSize,'\0',1);  
			}  
  
			// Now strip down the serialized object  
  
			unsigned long newObjectSize = anObject->serializedObjectSize - valueSize - 4;  
  
			BYTE *buffer;  
  
			if (newObjectSize == 0)  
			{  
				buffer = NULL;  
			}  
			else  
			{  
				buffer = new BYTE [newObjectSize]; 
				
				if (buffer == NULL)
				{
					//Can't allocate buffer, return NULL
					return NULL;
				}
  
				memcpy (buffer,anObject->serializedObject + valueSize + 4, newObjectSize);  
			}  
  
			delete anObject->serializedObject;  
			anObject->serializedObject = buffer;  
			anObject->serializedObjectSize = newObjectSize;  
		  
		}  
	}  
	else  
	{  
		if (anObject->serializedObject != NULL)  
		{  
			memcpy (&valueSize, anObject->serializedObject +  
				m_bSerialMultiPassFillOffset, 4);

			valueSize = ntohl (valueSize);
  
			m_bSerialMultiPassFillOffset += 4;  
  
			if (valueSize == 0)  
			{  
			// Set string empty  
			valuePtr = new char [1];  
			valuePtr[0] = '\0';  
			}  
			else  
			{  
				valuePtr = new char [valueSize + 1];  

				if (valuePtr == NULL)
				{
					// Can't allocate buffer, return NULL
					return NULL;
				}

				memcpy (valuePtr, anObject->serializedObject +  
					m_bSerialMultiPassFillOffset, valueSize);  
  
				m_bSerialMultiPassFillOffset += valueSize;  
  
				memset (valuePtr + valueSize,'\0',1);  
			}  
		}  
	}  
  
	return valuePtr;  
}  
          
unsigned long CObject::GetBytesFromSerialObject (BYTE **value,SerializedObject *anObject)  
{  
	unsigned long valueSize;  
  
	BYTE *valuePtr;  
  
	if (m_bSerialMultiPass == FALSE)  
	{  
		if (anObject->serializedObject != NULL)  
		{  
			memcpy (&valueSize, anObject->serializedObject, 4);  

			valueSize = ntohl (valueSize);
  
			if (valueSize == 0)  
			{  
				valuePtr = NULL;  
			}  
			else  
			{  
				valuePtr = new BYTE [valueSize];  

				if (valuePtr == NULL)
				{
					// Can't allocate buffer, return 0
					*value = NULL;
					return 0;
				}

				memcpy (valuePtr, anObject->serializedObject + 4, valueSize);  
			}  
  
			// Now strip down the serialized object  
  
			unsigned long newObjectSize = anObject->serializedObjectSize - valueSize - 4;  
  
			BYTE *buffer;  
  
			if (newObjectSize == 0)  
			{  
				buffer = NULL;  
			}  
			else  
			{  
				buffer = new BYTE [newObjectSize];    

				if (buffer == NULL)
				{
					// Can't allocate buffer, return 0
					*value = NULL;
					return 0;
				}

				memcpy (buffer,anObject->serializedObject + valueSize + 4, newObjectSize);  
			}  
  
			delete anObject->serializedObject;  
			anObject->serializedObject = buffer;  
			anObject->serializedObjectSize = newObjectSize;  
		  
		}  
		else  
		{  
			valuePtr = NULL;  
		}  
  
		*value = valuePtr;  
	}  
	else  
	{  
		if (anObject->serializedObject != NULL)  
		{  
			memcpy (&valueSize, anObject->serializedObject +  
				m_bSerialMultiPassFillOffset, 4);  

			valueSize = ntohl (valueSize);
  
			m_bSerialMultiPassFillOffset += 4;  
  
			if (valueSize == 0)  
			{  
				valuePtr = NULL;  
			}  
			else  
			{  
				valuePtr = new BYTE [valueSize];  

				if (valuePtr == NULL)
				{
					// Can't allocate buffer, return NULL
					*value = NULL;
					return 0;
				}

				memcpy (valuePtr, anObject->serializedObject +  
					m_bSerialMultiPassFillOffset, valueSize);  
  
				m_bSerialMultiPassFillOffset += valueSize;  
			}  
  
			*value = valuePtr;  
		}  
	}  
  
	return valueSize;  
}  
 
char *CObject::Description (void) 
{ 
	return m_szDescriptionBuffer; 
} 
 
void CObject::AddToDescription (CObject *object, char *format, ...) 
{ 
	char buffer[256]; 
	va_list arguments; 

	va_start(arguments,format); 
	
	_vsnprintf(buffer,sizeof(buffer),format,arguments); 

	va_end(arguments); 

	// Now add this buffer to the current description 
	unsigned long newBufferSize; 

	newBufferSize = strlen (m_szDescriptionBuffer) + strlen (buffer) + 2; 

	char *newBuffer = new char [newBufferSize]; 
	memset (newBuffer,0,newBufferSize); 
	
	_snprintf (newBuffer,newBufferSize + 1,"%s\n%s",m_szDescriptionBuffer,buffer); 

	// Now delete old description buffer 
	delete m_szDescriptionBuffer; 

	m_szDescriptionBuffer = newBuffer; 
} 
 
void CObject::CreateDescription (void) 
{	 
	AddToDescription (this,"m_szName : %s",m_sName); 
	AddToDescription (this,"m_szType : %s",m_sType); 
} 
 
void CObject::Trace (char *file, int line, unsigned long mask, char *format, ...) 
{ 
	// First check if m_Logger is already set 
	if (m_Logger == NULL) 
	{ 
		// First check if the LoggerManager is instanciated 
		CMasterManager *master = CMasterManager::Instance(); 
		CLoggerManager *logger = (CLoggerManager *)master->GetManager("Logger"); 

		if (logger == NULL) 
		{ 
			// Logger not instanciated 
			m_Logger = NULL; 
			return; 
		} 

		m_Logger = logger; 
	} 

	if (m_Logger != NULL) 
	{ 
		char bufferObjectDesc[256]; 
		memset (bufferObjectDesc,0,sizeof(bufferObjectDesc));

		_snprintf (bufferObjectDesc,sizeof(bufferObjectDesc),"Object name : %s type : %s",GetName(),GetType()); 

		char bufferInfo[1024]; 
		va_list arguments; 

		va_start(arguments,format); 		
		_vsnprintf(bufferInfo,sizeof(bufferInfo),format,arguments); 
		va_end(arguments); 

		char buffer[2000]; 

		_snprintf (buffer,sizeof(buffer),"%s # %s",bufferObjectDesc,bufferInfo); 

		m_Logger->Log (file,line,mask,buffer); 
	} 
} 
