// LoggerManagerModule_File.cpp: implementation of the CLoggerManagerModule_File class. 
// 
////////////////////////////////////////////////////////////////////// 
 
#include "../../Include/Base/LoggerManagerModule_File.h" 
 
#include <string.h> 
 
////////////////////////////////////////////////////////////////////// 
// Construction/Destruction 
////////////////////////////////////////////////////////////////////// 
 
CLoggerManagerModule_File::CLoggerManagerModule_File() : CLoggerManagerModule ("File") 
{ 
	memset (m_szFileName,0,sizeof(m_szFileName)); 
	m_File = NULL; 
} 
 
CLoggerManagerModule_File::~CLoggerManagerModule_File() 
{ 
	if (m_File != NULL) 
	{ 
		// Close file 
		fclose (m_File); 
	} 
} 
 
void CLoggerManagerModule_File::Log (char *text) 
{ 
	if (m_File != NULL) 
	{ 
		fwrite (text,sizeof(char),strlen(text),m_File); 
		// And add \n 
		fwrite ("\n",1,1,m_File); 
		fflush (m_File); 
	} 
} 
 
void CLoggerManagerModule_File::SetFileName (char *fileName) 
{ 
	strncpy (m_szFileName,fileName,sizeof(m_szFileName)); 
} 
 
BOOL CLoggerManagerModule_File::OpenFile (void) 
{ 
	if ((m_File = fopen (m_szFileName,"a+")) == NULL) 
	{ 
		// Can't open file 
		return FALSE; 
	} 
 
	return TRUE; 
} 
 
BOOL CLoggerManagerModule_File::CloseFile (void) 
{ 
	if (fclose (m_File)) 
	{ 
		// Can't close file 
		return FALSE; 
	} 
 
	return TRUE; 
} 
