// ByteContainer.cpp  
//  
  
#include <stddef.h>  
#include <string.h>  
#include <stdio.h>  
  
#include "../../Include/Base/ByteContainer.h"  
   
// Implementation  
  
CByteContainer::CByteContainer() : CObject ("ByteContainer","Container")  
{  
	m_Bytes = NULL;  
	m_ulLength = 0;  
}  
      
    CByteContainer::~CByteContainer()   
    {  
    	if (m_Bytes != NULL)  
    	{  
    		delete m_Bytes;  
    	}  
    }  
      
    void CByteContainer::SetBytes (BYTE *bytes, unsigned long length)  
    {  
    	if (bytes != NULL)  
    	{  
    		if (m_Bytes != NULL)  
    		{  
    			delete [] m_Bytes;  
    		}  
    		m_Bytes = new BYTE [length];  
    		memcpy (m_Bytes,bytes,length);  
    		m_ulLength = length;  
    	}  
    }  
      
    BOOL CByteContainer::GetBytes (BYTE *bytes, unsigned long length)  
    {  
    	if (m_ulLength > length)  
    	{  
    		return FALSE;  
    	}  
      
    	memcpy (bytes,m_Bytes,m_ulLength);  
    
    	return TRUE;  
    }  
      
    unsigned long CByteContainer::GetLength (void)  
    {  
    	return m_ulLength;  
    }  
