    // MessageStack.h: interface for the CMessageStack class.
    //
    //////////////////////////////////////////////////////////////////////
    
#ifndef __MESSAGESTACK__
#define __MESSAGESTACK__

// Platform specific definitions
#include "../../Include/Base/platform.h"

#include "../../Include/Base/Object.h"
    
class CMessage;

class CMessageStack : public CObject  
{
public:
    CMessageStack();
    virtual ~CMessageStack();

    void PutMessage (CMessage *aMessage);
    BOOL IsMessageAvailable (void);
    CMessage *GetMessage (void);
    CMessage *PeekMessage (void);
    CMessage *GetMessageForID (unsigned long);

	PASS_SYNCH lock;

protected:

    struct __MessageStackElement 
    {
    	CMessage *message;
    	__MessageStackElement *next;
    };

    __MessageStackElement *m_StackTop;
    __MessageStackElement *m_StackBottom;

    unsigned long m_ulMessageCount;
};
    
#endif // __MESSAGESTACK__

