// Connection.h: interface for the CConnection class.
//
//////////////////////////////////////////////////////////////////////

#ifndef __CONNECTION__
#define __CONNECTION__

// Platform specific definitions
#include "../Base/platform.h"

#include "../Base/Thread.h"

class CMessage;
class CStringToObjectCollection;

class CConnection : public CThread
{
public:
	CConnection();
	CConnection(char *connectionType);
	virtual ~CConnection();

	virtual BOOL Open (void) = 0;
	virtual BOOL Close (void) = 0;

    virtual CMessage *GetMessageForID (unsigned long messageID) = 0;
    virtual CMessage *WaitMessageForID (unsigned long messageID) = 0;

	void SetConnectionName (char *name);
	void GetConnectionName (char *name,unsigned long length);

	void SetConnectionID (unsigned long id);
	unsigned long GetConnectionID (void);

	void SetConnectionInfo (char *info);
	void GetconnectionInfo (char *info, unsigned long length);

	virtual BOOL SetConnectionParam (CStringToObjectCollection *param) = 0;

	BOOL GetConnectionBreak (void);
    void SetConnectionBreak (void);

	virtual unsigned long SendMessage (CMessage *) = 0;
	unsigned long SendAndGetBackMessage (CMessage *);

protected:
	char *m_szConnectionName;
   	BOOL m_bConnectionBreak;

	unsigned long m_ulConnectionID;
	char *m_szConnectionInfo; // for IP Connection, it's the ip address the one the client is connected
};

#endif // __CONNECTION__
