    // Thread.h: interface for the CThread class. 
    // 
    ////////////////////////////////////////////////////////////////////// 
     
  #ifndef __THREAD__ 
  #define __THREAD__ 
   
  #include "../../Include/Base/platform.h" 
   
  #include "../../Include/Base/Object.h" 
 
  #ifdef linux 
  #include <pthread.h> 
  #endif // linux 
     
  #ifdef __SCO__ 
  #include <thread.h> 
#include <synch.h>
  #endif // __SCO__ 

#ifdef __BEOS__
	#include <OS.h>
#endif // __BEOS__    
 
  #ifdef __HPUX__ 
 #include <pthread.h> 
  #endif // __HPUX__ 
     
    class PASS_CLASS_THREAD : public CObject   
    { 
    public: 
    	CThread(); 
    	CThread(char *name, char *type = "Thread"); 
    	virtual ~CThread(); 
     
    	DWORD Start (void); 
    	DWORD Stop (void); 
     
    	void Kill (void); 
     
    	void SetTickTime (DWORD time); 
     
    	BOOL IsRunning (); 
    	void Release (void); 
     
    	unsigned long GetThreadHandle (void); 

		void CreateDescription (void);
     
    protected: 
     
    	virtual void PreRun (void); 
    	virtual void Run (void); 
    	virtual void Tick (void); 
    	virtual void PostRun (void); 
     
  #ifdef _WIN32 
    	HANDLE m_hCloseEvent; 
    	HANDLE m_hThread; 
  #endif //_WIN32 
  #ifdef linux 
  		int m_CloseFlag; 
  		pthread_t m_hThread; 
  #endif // linux 
	#ifdef __SCO__ 
		int m_CloseFlag; 
		thread_t m_hThread; 
	#endif // __SCO__     
	#ifdef __BEOS__ 
		int m_CloseFlag; 
		thread_id m_hThread; 
	#endif // __BEOS__     
	#ifdef __HPUX__ 
		int m_CloseFlag; 
		pthread_t m_hThread; 
	#endif // __HPUX__     
     
    private:      
    	unsigned long InternalHandler (void);      
    	DWORD m_dwTickTime;      
    	BOOL m_bRunningFlag; 
        
  #ifdef _WIN32 
    	static DWORD WINAPI ThreadProc (void *mySelf); 
  #endif //_WIN32 
  #ifdef linux 
	  	static void *ThreadProc (void *mySelf); 
  #endif //linux 
  #ifdef __SCO__ 
	  	static void *ThreadProc (void *mySelf); 
  #endif // __SCO__ 
  #ifdef __BEOS__ 
	  	static int32 ThreadProc (void *mySelf); 
  #endif // __BEOS__ 
  #ifdef __HPUX__ 
	  	static void *ThreadProc (void *mySelf); 
  #endif // __HPUX__ 
  protected: 
  #ifdef linux 
		pthread_attr_t m_attribute; 
		pthread_mutex_t m_InternalLock; 
  #endif // linux 
#ifdef __SCO__
	mutex_t m_InternalLock;
#endif // __SCO__
#ifdef __BEOS__
	PASS_SYNCH m_InternalLock;
#endif // __BEOS__
  #ifdef __HPUX__ 
		pthread_attr_t attribute; 
		pthread_mutex_t m_InternalLock; 
  #endif // __HPUX__ 
    }; 
     
#endif // __THREAD__ 
