// ObjectManager.h: interface for the ObjectManager class. 
// 
////////////////////////////////////////////////////////////////////// 
 
#ifndef __OBJECTMANAGER__ 
#define __OBJECTMANAGER__ 
 
// platform specific declaration     
#include "../../Include/Base/platform.h" 
  
#include "../../Include/Base/Object.h" 
     
    class CLongToObjectCollection; 
 
    class CObjectManager : public CObject 
    { 
    public: 
     
    	static CObjectManager* Instance();  
     
    	virtual ~CObjectManager(); 
     
    	BOOL RegisterObject (CObject *anObject); 
    	BOOL RegisterObjectByName (CObject *anObject, char *name); 
    	BOOL RegisterObjectByNameAndType (CObject *anObject, char *name, char *type); 
    	CObject *CreateByName (char *name); 
    	CObject *CreateByNameAndType (char *name, char *type); 
    	CObject *CreateBySerializedObject (struct SerializedObject*); 
     
    	CLongToObjectCollection *GetObjectsForType (char *type);
        void RemoveAll();
     
    protected: 
     
    	CObjectManager(); 
     
    	struct __ObjectList 
    	{ 
    		__ObjectList *nextObject; 
    		char *objectName; 
    		char *objectType; 
    		CObject *classObject; 
    	}; 

		PASS_SYNCH lock;
     
    private: 
     
    	unsigned long currentObjectID; 
    	__ObjectList *firstObject; 
    	__ObjectList *lastObject; 
     
    	static CObjectManager* m_instance;      
    }; 
     
#endif // __OBJECTMANAGER__ 
