// LoggerManager.h: interface for the CLoggerManager class.
//
//////////////////////////////////////////////////////////////////////

#ifndef __LOGGERMANAGER__
#define __LOGGERMANAGER__

#include "../../Include/Base/Manager.h"

#define LOGMASK_NONE 0
#define LOGMASK_BASE 0x0001
#define LOGMASK_COMM 0x0002
#define LOGMASK_CRYPTO 0x0004
#define LOGMASK_COMM_EX 0x0008
#define LOGMASK_CHECKMEMORY 0x0010
#define LOGMASK_FULL 0xFFFF

class CStringToObjectCollection;
class CLoggerManagerModule;
 
class CLoggerManager : public CManager  
{
public:
	CLoggerManager();
	virtual ~CLoggerManager();

	void SetLogLevel (unsigned long mask); // see defines for mask meening
	unsigned long GetLogLevel (void);

	void Log (char *file, int line, unsigned long mask, char *text);

	void AddModule (char *moduleName, CLoggerManagerModule *module);
	void AddModule (CLoggerManagerModule *module);
	BOOL EnableModule (char *moduleName);
	BOOL DisableModule (char *moduleName);
	
protected:

	PASS_SYNCH lock;

	unsigned long m_ulLogLevelMask;
	CStringToObjectCollection *m_ModuleList;
	CStringToObjectCollection *m_EnabledModuleList;
};

#endif // __LOGGERMANAGER__
