TOPDIR = ..\..

TARGET                  = belpic.dll
TARGET2                 = scgui_win32.res 
CEVI                    = cevi\belpic.dll

HEADERS			= opensc.h pkcs15.h emv.h \
			  errors.h types.h \
			  cardctl.h asn1.h log.h

HEADERSDIR		= $(TOPDIR)\src\include\opensc

OBJECTS			= sc.obj ctx.obj module.obj asn1.obj log.obj base64.obj padding.obj \
			  errors.obj sec.obj card.obj iso7816.obj dir.obj ctbcs.obj \
			  portability.obj \
			  pkcs15.obj pkcs15-cert.obj pkcs15-data.obj pkcs15-pin.obj \
			  pkcs15-prkey.obj pkcs15-pubkey.obj pkcs15-sec.obj \
			  pkcs15-wrap.obj pkcs15-algo.obj \
			  pkcs15-cache.obj reader-pcsc.obj \
			  card-belpic.obj scgui_win32.obj $(TARGET2)

RSC_PROJ=/l 0x813 /fo"scgui_win32.res"
GUI_RC = scgui_win32.rc

all: install-headers $(TARGET2) $(TARGET) $(CEVI)

!INCLUDE $(TOPDIR)\win32\Make.rules.mak

$(TARGET): $(OBJECTS) $(TARGET2)
    if exist ctx.obj.original  del /Q ctx.obj.original ctx.obj
    if exist card-belpic.obj.original  del /Q card-belpic.obj.original card-belpic.obj
	perl $(TOPDIR)\win32\makedef.pl $*.def $* $(OBJECTS)
	link $(LINKFLAGS) /dll /def:$*.def /implib:$*.lib /out:$(TARGET) $(OBJECTS) ..\scconf\scconf.lib ..\scdl\scdl.lib ..\..\..\pcscproxy\winscarp.lib \
		advapi32.lib gdi32.lib user32.lib shell32.lib ole32.lib

$(TARGET2): $(GUI_RC)
	rc $(RSC_PROJ) $(GUI_RC)


# For the RA-PC on the communities, it should be possible to install 2 independent
# middlewares: one normal, full version, and one that is used by the RA-PC.
# The one from the RA-PC consists only of the pkcs11 and belpic DLLs and a belpic.conf
# file, all installed in a local dir (not %windir%).
# Therefore, a slightly different belpic.dll is needed: one that (1) doesn't look for
# belpic.conf in %windir% but instead looks in the current dir and (2) links to
# winscard.lib instead of winscarp.lib (the proxy).
# This is done below:
# - backup ctx.obj card-belpic.obj
# - recompile ctx.c into ctx.obj with the OPENSC_CONF_LOCAL define
# - recompile card-belpic.c into card-belpic.obj with the NO_BELPIC_SERVICE define
# - build a new belpic.dll in subdirectory cevi\ and link with winscard.lib
# - restore the orginal ctx.obj and card-belpic.obj

$(CEVI): $(OBJECTS) $(TARGET2)
	copy /Y ctx.obj ctx.obj.original
	copy /Y card-belpic.obj card-belpic.obj.original
	cl $(COPTS) /DOPENSC_CONF_LOCAL /c ctx.c
	cl $(COPTS) /DNO_BELPIC_SERVICE /c card-belpic.c
	if not exist cevi mkdir cevi
	perl $(TOPDIR)\win32\makedef.pl $*.def $* $(OBJECTS)
	link $(LINKFLAGS) /dll /def:$*.def /implib:$*.lib /out:$(CEVI) $(OBJECTS) ..\scconf\scconf.lib ..\scdl\scdl.lib winscard.lib \
		advapi32.lib gdi32.lib user32.lib shell32.lib ole32.lib
	mv -f ctx.obj.original ctx.obj
	mv -f card-belpic.obj.original card-belpic.obj
