/*
 * pkcs11 low level testing
 *
 * Copyright (C) 2002  Zetes
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "pkcs11-lowlevel.h"

int c_SetPin()
{
	char *szOldPin = "1234";
	char *szNewPin = "1111";

	int errors = 0;
	CK_SESSION_HANDLE session;
	CK_BYTE pOldPin[12];
	CK_BYTE pNewPin[12];
	CK_ULONG ulOldLen;
	CK_ULONG ulNewLen;
	CK_RV rv;
	CK_BBOOL isPAP;

	if (p11->C_Initialize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Initialize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}

	isPAP = slotWithTokenIsPAP();

	printf("C_SetPIN %s\n", isPAP ? "with pin pad reader" : "with pin = 1234");

	printf("  Cat 1\n");

	ulOldLen = strlen(szOldPin);
	ulNewLen = strlen(szNewPin);
	memcpy(pOldPin, szOldPin, ulOldLen);
	memcpy(pNewPin, szNewPin, ulNewLen);

	session = getSessionInFirstSlot();

	/* test 1 */
	if (p11->C_SetPIN(12345, pOldPin, ulOldLen, pNewPin, ulNewLen) != CKR_SESSION_HANDLE_INVALID) {
		printf("    ERR: C_SetPIN(1) didn't return CKR_SESSION_HANDLE_INVALID\n");
		errors++;
	}

	/* test 2 */
	memcpy(pOldPin, "1111", 4); /* fixme */
	ulOldLen = 4;
	if (isPAP)
		printf("    Change your PIN on the pin pad reader with a wrong PIN\n");
	if ((rv = p11->C_SetPIN(session, pOldPin, ulOldLen, pNewPin, ulNewLen)) != CKR_PIN_INCORRECT) {
		printf("    ERR: C_SetPIN(3) didn't return CKR_INCORRECT_PIN but %s\n", CKR2Str(rv));
		exit(++errors);
	}

	/* test 3 */
	memcpy(pNewPin, "1", 1);
	ulNewLen = 1;
	if ((rv = p11->C_SetPIN(session, pOldPin, ulOldLen, pNewPin, ulNewLen)) != CKR_PIN_LEN_RANGE) {
		printf("    ERR: C_SetPIN(4) didn't return CKR_PIN_LEN_RANGE but %s\n", CKR2Str(rv));
		exit(++errors);
	}

	/* test 4 */
	ulOldLen = strlen(szOldPin);
	ulNewLen = strlen(szNewPin);
	memcpy(pOldPin, szOldPin, ulOldLen);
	memcpy(pNewPin, szNewPin, ulNewLen);
	if (isPAP)
		printf("    Change your PIN on the pin pad reader to a new value\n");
	if (p11->C_SetPIN(session, pOldPin, ulOldLen, pNewPin, ulNewLen) != CKR_OK) {
		printf("    ERR: C_SetPIN(5) didn't return CKR_OK\n");
		errors++;
	}
	/* change back */
	if (isPAP)
		printf("    Change your PIN back on the pin pad reader to old value\n");
	if (p11->C_SetPIN(session, pNewPin, ulNewLen, pOldPin, ulOldLen) != CKR_OK) {
		printf("    ERR: C_SetPIN(5) didn't return CKR_OK\n");
		errors++;
	}

	/* test5 */
	if (p11->C_Finalize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Finalize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}
	if (p11->C_SetPIN(12345, pOldPin, ulOldLen, pNewPin, ulNewLen) != CKR_CRYPTOKI_NOT_INITIALIZED) {
		printf("    ERR: C_SetPIN(6) didn't return CKR_CRYPTOKI_NOT_INITIALIZED\n");
		errors++;
	}

	return errors;
}


int c_SetPin_PP()
{
	int errors = 0;
	CK_SESSION_HANDLE session;
	CK_RV rv;
	CK_BBOOL isPAP;

	if (p11->C_Initialize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Initialize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}

	isPAP = slotWithTokenIsPAP();

	printf("C_SetPin with pin pad reader, Category 2 tests\n");

	if (!isPAP) {
		printf("  No pin pad reader present, can't do this test, exiting\n");
		exit(0);
	}

	session = getSessionInFirstSlot();

	/* test 1 */
	printf("    Change your PIN on the pin pad reader a new value\n");
	if ((rv = p11->C_SetPIN(session, NULL, 0, NULL, 0)) != CKR_OK) {
		printf("    ERR: C_SetPIN(change) didn't return CKR_OK but %s\n", CKR2Str(rv));
		exit(++errors);
	}
	/* change back */
	printf("    Change your PIN back on the pin pad reader to old value\n");
	if ((rv = p11->C_SetPIN(session, NULL, 0, NULL, 0)) != CKR_OK) {
		printf("    ERR: C_SetPIN(changeback) didn't return CKR_OK but %s\n", CKR2Str(rv));
		exit(++errors);
	}

	return errors;
}
