/*
 * pkcs11 low level testing
 *
 * Copyright (C) 2002  Zetes
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "pkcs11-lowlevel.h"

int c_GetMechanismList()
{
	int errors = 0;
	CK_SLOT_ID slotID1, slotID2;
	CK_MECHANISM_TYPE mechList[100];
	CK_ULONG nMechs = sizeof(mechList);

	printf("C_GetMechanismList\n");

	printf("  Cat 1\n");

	if (p11->C_Initialize(NULL_PTR) != CKR_OK) {
		printf("    C_Initialize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}

	if (p11->C_GetMechanismList(12345, mechList, &nMechs) != CKR_SLOT_ID_INVALID) {
		printf("    C_GetMechanismList(1) didn't return CKR_SLOT_ID_INVALID\n");
		errors++;
	}

	slotID1 = getFirstSlot(1);

	if (p11->C_GetMechanismList(slotID1, mechList, &nMechs) != CKR_OK) {
		printf("    C_GetMechanismList(2) didn't return CKR_OK\n");
		errors++;
	}

	slotID1 = getFirstSlot(0);
	if (p11->C_GetMechanismList(slotID1, mechList, &nMechs) != CKR_TOKEN_NOT_PRESENT) {
		printf("    C_GetMechanismList(3) didn't return CKR_TOKEN_NOT_PRESENT\n");
		errors++;
	}

	printf("  Cat 2\n");

	slotID1 = getFirstSlot(1);

	if (p11->C_GetMechanismList(slotID1, NULL_PTR, &nMechs) != CKR_OK) {
		printf("    C_GetMechanismList(1) didn't return CKR_OK\n");
		errors++;
	}
	if (nMechs < 1) {
		printf("    C_GetMechanismList(1) didn't return any mechanisms\n");
		errors++;
	}

	nMechs = 0;
	if (p11->C_GetMechanismList(slotID1, mechList, &nMechs) != CKR_BUFFER_TOO_SMALL) {
		printf("    C_GetMechanismList(2) didn't return CKR_BUFFER_TOO_SMALL\n");
		errors++;
	}

	nMechs = sizeof(mechList);
	if (p11->C_GetMechanismList(slotID1, mechList, &nMechs) != CKR_OK) {
		printf("    C_GetMechanismList(3) didn't return CKR_OK\n");
		errors++;
	}

	if (p11->C_Finalize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Finalize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}
	if (p11->C_GetMechanismList(slotID1, mechList, &nMechs) != CKR_CRYPTOKI_NOT_INITIALIZED) {
		printf("    C_GetMechanismList(4) didn't return CKR_CRYPTOKI_NOT_INITIALIZED\n");
		errors++;
	}

	return errors;
}
