/*
 * pkcs11 low level testing
 *
 * Copyright (C) 2002  Zetes
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "pkcs11-lowlevel.h"

int c_GetInfo()
{
	int errors = 0;
	CK_INFO info;
	CK_RV rv;

	printf("C_GetInfo\n");

	if (p11->C_Initialize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Initialize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}

	if ((rv = p11->C_GetInfo(NULL)) != CKR_ARGUMENTS_BAD) {
		printf("    ERR: C_GetInfo(1) didn't return CKR_ARGUMENTS_BAD but %s\n", CKR2Str(rv));
		errors++;
	}

	if (p11->C_GetInfo(&info) != CKR_OK) {
		printf("    ERR: C_GetInfo(2) didn't return CKR_OK\n");
		errors++;
	}
	/* SHOULD WE TEST THIS ??? */
	if (info.cryptokiVersion.major != 2 && info.cryptokiVersion.minor != 11) {
		printf("    ERR: cryptokiVersion != 2.11\n");
		errors++;
	}

	if (p11->C_Finalize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Finalize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}
	if (p11->C_GetInfo(&info) != CKR_CRYPTOKI_NOT_INITIALIZED) {
		printf("    ERR: C_GetInfo(2) didn't return CKR_CRYPTOKI_NOT_INITIALIZED\n");
		errors++;
	}

	return errors;
}

