/*
 * pkcs11 low level testing
 *
 * Copyright (C) 2002  Zetes
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "pkcs11-lowlevel.h"

int c_Finalize()
{
	int errors = 0, a = 0;

	printf("C_Finalize\n");
	/* Test 1: Call C_Finalize after a C_Initialize
	   => allready done in c_initialize() */

	if (p11->C_Finalize(NULL_PTR) != CKR_CRYPTOKI_NOT_INITIALIZED) {
		printf("    ERR: C_Finalize(2) didn't return CKR_CRYPTOKI_NOT_INITIALIZED\n");
		errors++;
	}

	if (p11->C_Finalize(NULL_PTR) != CKR_CRYPTOKI_NOT_INITIALIZED) {
		printf("    ERR: C_Finalize(3) didn't return CKR_CRYPTOKI_NOT_INITIALIZED\n");
		errors++;
	}

	if (p11->C_Initialize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Initialize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}
	if (p11->C_Finalize(&a) != CKR_ARGUMENTS_BAD) {
		printf("    ERR: C_Finalize(4) didn't return CKR_ARGUMENTS_BAD\n");
		errors++;
	}

	p11->C_Finalize(NULL_PTR);

	return errors;
}
