#include <Carbon/Carbon.h>
#include <CoreFoundation/CFBundle.h>
#include "scgui.h"

#define MIN_PIN_LEN 4
#define MAX_PIN_LEN 20

#define kSignat		'pind'
#define kOKCommand	'buok'
#define kCancelCommand	'bcan'
#define kMsgFieldID		129
#define kPinFieldID		130
#define kOKButtonID		131
#define kCancelbuttonID		132

WindowRef	window = NULL;

static char 	*g_pin;
static int 	g_pinLen;
static const 	char *g_pinTooShortMsg;
static int 	g_res;

pascal OSStatus MainWindowCommandHandler( EventHandlerCallRef handlerRef,
                                        EventRef event, void *userData );
static pascal void getPin( WindowRef window, char *pin, int pinLen );
static pascal void setMsg( WindowRef window, int kFieldID, const char *msg,
    int type, int setFocus );

scgui_ret_t scgui_init(void)
{
    CFBundleRef         inBundle;
    IBNibRef 		nibRef;
    int			res;

    /* Create a ref to the bundle containing the nib file */
    inBundle = CFBundleGetBundleWithIdentifier(CFSTR("be.eid.pkcs11"));
    if (inBundle == 0)  {
        /*printf("\nscgui_mac.c: CFBundleGetBundleWithIdentifier() failed\n\n");*/
        return SCGUI_ERROR;
    } 

    /* Create a Nib reference passing the name of the nib file. */
    //res = CreateNibReference(CFSTR("pindialog"), &nibRef);
    res = CreateNibReferenceWithCFBundle(inBundle, CFSTR("pindialog"), &nibRef);
    if (res != 0) {
        printf("\nscgui_mac.c: CreateNibReferenceWithCFBundle() returned 0x%0x (%d)\n\n", res, res);
        return SCGUI_ERROR;
    }

    /* Once the nib reference is created, set the menu bar. */
    res = SetMenuBarFromNib(nibRef, CFSTR("MenuBar"));
    if (res != 0) {
        printf("\nscgui_mac.c: SetMenuBarFromNib() returned 0x%0x (%d)\n\n", res, res);
        return SCGUI_ERROR;
    }
    
    /* Then create a window. "MainWindow" is the name of the window object. */
    res = CreateWindowFromNib(nibRef, CFSTR("MainWindow"), &window);
    if (res != 0) {
        printf("\nscgui_mac.c: CreateWindowFromNib() returned 0x%0x (%d)\n\n", res, res);
        return SCGUI_ERROR;
    }

    /* We don't need the nib reference anymore. */
    DisposeNibReference( nibRef);

    return SCGUI_OK;
}

scgui_ret_t scgui_enterpin(const char *title, const char *msg, char *pin, int *len,
                        const char *btn_ok, const char *btn_cancel,
                        const char *pinTooShort, scgui_param_t signIcon)
{
    EventTypeSpec 	commSpec = { kEventClassCommand, kEventProcessCommand };
    ControlID 		pinFieldID = { kSignat, kPinFieldID };
    ControlHandle	pinField;

    if (window == NULL)
        return SCGUI_NOT_INITED;

    g_pin = pin;
    g_pinLen = *len;
    g_pinTooShortMsg = pinTooShort;
    
    setMsg( window, kMsgFieldID, msg, kControlEditTextCFStringTag, 0 );

    GetControlByID( window, &pinFieldID, &pinField );
    SetKeyboardFocus( window, pinField, kControlFocusNextPart );

    ShowWindow( window );

    /* If an event occurs, MainWindowCommandHandler() is called */
    InstallWindowEventHandler( window, NewEventHandlerUPP(MainWindowCommandHandler),
        1, &commSpec, (void *) window, NULL );

    /* Call the event loop. */
    RunApplicationEventLoop();

    /*
     * Event loop is done because QuitApplicationEventLoop() was called
    */

    /* Make the window invisible */
    ShowHide( window, false);

    pin = g_pin;
    *len = strlen(pin);

    return g_res;
}

scgui_ret_t scgui_ask_message(const char *title,
	const char *short_msg, const char *long_msg,
	const char *btn_ok, const char *btn_cancel,
	const char *pinpad_reader)
{
    /* Only needed for pinpad and single-sign on */
    return SCGUI_OK;
}

pascal OSStatus MainWindowCommandHandler( EventHandlerCallRef handlerRef,
                                        EventRef event, void *userData )
{
    OSStatus	err = eventNotHandledErr;
    HICommand	command;
    int		pinLen = g_pinLen;

    GetEventParameter( event, kEventParamDirectObject, typeHICommand, NULL,
            sizeof(HICommand), NULL, &command );

    switch( command.commandID ) {
    case kOKCommand:
        getPin( (WindowRef) userData, g_pin, pinLen );
        setMsg( (WindowRef) userData, kPinFieldID, "" ,
            kControlEditTextPasswordCFStringTag, 1 );
        if (strlen(g_pin) < MIN_PIN_LEN) {
            setMsg( (WindowRef) userData, kMsgFieldID,
                g_pinTooShortMsg, kControlEditTextCFStringTag,  0 );
        }
        else {
            g_res = SCGUI_OK;
            QuitApplicationEventLoop(); /* done, stop event loop */
        }
        err = noErr;
        break;
    case kCancelCommand:
        g_res = SCGUI_CANCEL;
        QuitApplicationEventLoop(); /* done, stop event loop */
        err = noErr;
        break;
    }

    return err;
}

pascal void getPin( WindowRef window, char *pin, int pinLen )
{
    ControlHandle	pinField;
    ControlID 		pinControlID = { kSignat, kPinFieldID };
    CFStringRef		text;
    Size 		actualSize = 12;
    CFIndex		pLen;

    GetControlByID( window, &pinControlID, &pinField );

    GetControlData( pinField, 0, kControlEditTextPasswordCFStringTag,
        sizeof(CFStringRef), &text, &actualSize );
    actualSize = MAX_PIN_LEN; /* weird: actualSize is allways 4 ?!?! */

    memset(pin, 0, sizeof(pin));
    CFStringGetBytes(text, CFRangeMake(0, actualSize), 0,
        0x32, 0, pin, pinLen,  &pLen);
}

pascal void setMsg( WindowRef window, int kFieldID, const char *msg,
    int type, int setFocus )
{
    CFStringRef		text;
    ControlID 		fieldID = { kSignat, kFieldID };
    ControlHandle	field;

    GetControlByID( window, &fieldID, &field );
    text = CFStringCreateWithFormat( NULL, NULL, CFSTR("%s"), msg );
    SetControlData( field, 0, type, sizeof(CFStringRef), &text );
    CFRelease( text );
    if ( setFocus )
        /* ?? Doesn't seem to work */
        SetKeyboardFocus( window, field, kControlFocusNextPart );
    DrawOneControl( field );
}

/* Some header files:
/System/Library/Frameworks/Carbon.framework/Versions/A/Frameworks/HIToolbox.framework/Versions/A/Headers/ControlDefinitions.h
/System/Library/Frameworks/Carbon.framework/Versions/A/Frameworks/HIToolbox.framework/Versions/A/Headers/CarbonEvents.h
/System/Library/Frameworks/CoreFoundation.framework/Versions/A/Headers/CFString.h
*/

