
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bseprocedure.proc"

#include "bseplugin.h"
#include "bseprocedure.h"
#include "bsescripthelper.h"
#include "bseserver.h"
#line 21 "bseprocedure.proc"
#include "bsemath.h"    
#include "bsemain.h"
#line 23 "bseprocedure.proc"
#include <string.h>     
#line 24 "bseprocedure.proc"
#include <stdlib.h>     


#line 29 "bseprocedure.proc"

/* --- bse-note-to-freq --- */
static void
bse_note_to_freq_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 30 "bseprocedure.proc"
 {
#line 32 "bseprocedure.proc"
  *(in_pspecs++)    = bse_param_spec_enum ("musical_tuning", "Musical Tuning", NULL,
			       BSE_MUSICAL_TUNING_12_TET, BSE_TYPE_MUSICAL_TUNING_TYPE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_pspec_note_simple ("note", "Note", NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", NULL);
  *(out_pspecs++)   = sfi_pspec_real ("frequency", "Frequency", NULL,
			  BSE_KAMMER_FREQUENCY, 0, BSE_MAX_FREQUENCY, 0.1,
			  SFI_PARAM_STANDARD);
#line 39 "bseprocedure.proc"
}  }
static BseErrorType
#line 39 "bseprocedure.proc"
bse_note_to_freq_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 42 "bseprocedure.proc"
{
#line 43 "bseprocedure.proc"
  
  BseMusicalTuningType musical_tuning = g_value_get_enum (in_values++);
  int                  note           = sfi_value_get_int (in_values++);
  int                  fine_tune      = sfi_value_get_int (in_values++);
  BseNoteDescription *info;
  gfloat freq;
  
#line 50 "bseprocedure.proc"
  
  info = bse_note_description (musical_tuning, note, fine_tune);
  if (!info->name)
    freq = 0;
  else
    freq = info->freq;
  bse_note_description_free (info);
  
#line 58 "bseprocedure.proc"
  
  sfi_value_set_real (out_values++, freq);
  
  return BSE_ERROR_NONE;
}

/* --- bse-note-from-freq --- */
static void
bse_note_from_freq_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 64 "bseprocedure.proc"
 {
#line 66 "bseprocedure.proc"
  *(in_pspecs++)    = bse_param_spec_enum ("musical_tuning", "Musical Tuning", NULL,
			       BSE_MUSICAL_TUNING_12_TET, BSE_TYPE_MUSICAL_TUNING_TYPE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_real ("frequency", "Frequency", NULL,
			  BSE_KAMMER_FREQUENCY, 0, BSE_MAX_FREQUENCY, 0.1,
			  SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_note ("note", "Note", NULL, SFI_KAMMER_NOTE, SFI_MIN_NOTE, SFI_MAX_NOTE, TRUE, SFI_PARAM_STANDARD);
#line 72 "bseprocedure.proc"
}  }
static BseErrorType
#line 72 "bseprocedure.proc"
bse_note_from_freq_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 75 "bseprocedure.proc"
{
#line 76 "bseprocedure.proc"
  
  BseMusicalTuningType musical_tuning = g_value_get_enum (in_values++);
  float                frequency      = sfi_value_get_real (in_values++);
  
#line 80 "bseprocedure.proc"
  
  sfi_value_set_int (out_values++, bse_note_from_freq (musical_tuning, frequency));
  
  return BSE_ERROR_NONE;
}

/* --- bse-note-describe --- */
static void
bse_note_describe_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 86 "bseprocedure.proc"
 {
#line 88 "bseprocedure.proc"
  *(in_pspecs++)    = bse_param_spec_enum ("musical_tuning", "Musical Tuning", NULL,
			       BSE_MUSICAL_TUNING_12_TET, BSE_TYPE_MUSICAL_TUNING_TYPE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_pspec_note_simple ("note", "Note", NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", NULL);
  *(out_pspecs++)   = bse_param_spec_boxed ("note-description", "Note Description", NULL,
                                BSE_TYPE_NOTE_DESCRIPTION, SFI_PARAM_STANDARD);
}
#line 95 "bseprocedure.proc"
 }
static BseErrorType
#line 95 "bseprocedure.proc"
bse_note_describe_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 98 "bseprocedure.proc"
{
#line 99 "bseprocedure.proc"
  
  BseMusicalTuningType musical_tuning = g_value_get_enum (in_values++);
  int                  note	      = sfi_value_get_int (in_values++);
  int                  fine_tune      = sfi_value_get_int (in_values++);
  
#line 104 "bseprocedure.proc"
  
  bse_value_take_boxed (out_values++, bse_note_description (musical_tuning, note, fine_tune));
  
  return BSE_ERROR_NONE;
}

/* --- bse-note-describe-from-freq --- */
static void
bse_note_describe_from_freq_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 110 "bseprocedure.proc"
 {
#line 112 "bseprocedure.proc"
  *(in_pspecs++)    = bse_param_spec_enum ("musical_tuning", "Musical Tuning", NULL,
			       BSE_MUSICAL_TUNING_12_TET, BSE_TYPE_MUSICAL_TUNING_TYPE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_real ("freq", "Frequency", NULL,
			  BSE_KAMMER_FREQUENCY,
			  0, BSE_MAX_FREQUENCY,
			  10.0, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("note-description", "Note Description", NULL,
                                BSE_TYPE_NOTE_DESCRIPTION, SFI_PARAM_STANDARD);
}
#line 121 "bseprocedure.proc"
 }
static BseErrorType
#line 121 "bseprocedure.proc"
bse_note_describe_from_freq_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 124 "bseprocedure.proc"
{
#line 125 "bseprocedure.proc"
  
  BseMusicalTuningType musical_tuning = g_value_get_enum (in_values++);
  float                freq	      = sfi_value_get_real (in_values++);
  gint note;
  
#line 130 "bseprocedure.proc"
  
  note = bse_note_from_freq (musical_tuning, freq);
  bse_value_take_boxed (out_values++, bse_note_description (musical_tuning, note, 0));
  
  return BSE_ERROR_NONE;
}

/* --- bse-note-from-string --- */
static void
bse_note_from_string_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 137 "bseprocedure.proc"
 {
#line 139 "bseprocedure.proc"
  *(in_pspecs++)    = bse_param_spec_enum ("musical_tuning", "Musical Tuning", NULL,
			       BSE_MUSICAL_TUNING_12_TET, BSE_TYPE_MUSICAL_TUNING_TYPE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("name", "Name", NULL,
			    "", SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("note-description", "Note Description", NULL,
                                BSE_TYPE_NOTE_DESCRIPTION, SFI_PARAM_STANDARD);
}
#line 146 "bseprocedure.proc"
 }
static BseErrorType
#line 146 "bseprocedure.proc"
bse_note_from_string_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 149 "bseprocedure.proc"
{
#line 150 "bseprocedure.proc"
  
  BseMusicalTuningType musical_tuning = g_value_get_enum (in_values++);
  char                *name           = sfi_value_get_string (in_values++);
  gint note;
  
#line 155 "bseprocedure.proc"
  
  note = bse_note_from_string (name);
  bse_value_take_boxed (out_values++, bse_note_description (musical_tuning, note, 0));
  
  return BSE_ERROR_NONE;
}

/* --- bse-note-construct --- */
static void
bse_note_construct_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 162 "bseprocedure.proc"
 {
#line 164 "bseprocedure.proc"
  *(in_pspecs++)    = bse_param_spec_enum ("musical_tuning", "Musical Tuning", NULL,
			       BSE_MUSICAL_TUNING_12_TET, BSE_TYPE_MUSICAL_TUNING_TYPE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("semitone", NULL, NULL,
			 9, 0, 11, 1,
			 SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_octave ("octave", NULL, NULL);
  *(in_pspecs++)    = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", NULL);
  *(out_pspecs++)   = bse_param_spec_boxed ("note-description", "Note Description", NULL,
                                BSE_TYPE_NOTE_DESCRIPTION, SFI_PARAM_STANDARD);
}
#line 174 "bseprocedure.proc"
 }
static BseErrorType
#line 174 "bseprocedure.proc"
bse_note_construct_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 177 "bseprocedure.proc"
{
#line 178 "bseprocedure.proc"
  
  BseMusicalTuningType musical_tuning = g_value_get_enum (in_values++);
  guint                semitone	      = sfi_value_get_int (in_values++);
  int                  octave	      = sfi_value_get_int (in_values++);
  int                  fine_tune      = sfi_value_get_int (in_values++);
  int note;
  
#line 185 "bseprocedure.proc"
  
  note = BSE_NOTE_GENERIC (octave, semitone);
  bse_value_take_boxed (out_values++, bse_note_description (musical_tuning, note, fine_tune));
  
  return BSE_ERROR_NONE;
}

/* --- bse-type-options --- */
static void
bse_type_options_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 192 "bseprocedure.proc"
 {
#line 194 "bseprocedure.proc"
  *(in_pspecs++)    = sfi_pspec_string ("type", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("string", NULL, NULL, NULL, SFI_PARAM_STANDARD);
#line 196 "bseprocedure.proc"
}  }
static BseErrorType
#line 196 "bseprocedure.proc"
bse_type_options_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 199 "bseprocedure.proc"
{
#line 200 "bseprocedure.proc"
  
  gchar *stype = sfi_value_get_string (in_values++);
  GType type;

#line 204 "bseprocedure.proc"
  
  if (!stype)
    return BSE_ERROR_PROC_PARAM_INVAL;

  type = g_type_from_name (stype);

#line 210 "bseprocedure.proc"
  
  sfi_value_set_string (out_values++, type ? bse_type_get_options (type) : NULL);

  return BSE_ERROR_NONE;
}

/* --- bse-type-blurb --- */
static void
bse_type_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 216 "bseprocedure.proc"
 {
#line 218 "bseprocedure.proc"
  *(in_pspecs++)    = sfi_pspec_string ("type", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("string", NULL, NULL, NULL, SFI_PARAM_STANDARD);
#line 220 "bseprocedure.proc"
}  }
static BseErrorType
#line 220 "bseprocedure.proc"
bse_type_blurb_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 223 "bseprocedure.proc"
{
#line 224 "bseprocedure.proc"
  
  gchar *stype = sfi_value_get_string (in_values++);
  GType type;

#line 228 "bseprocedure.proc"
  
  if (!stype)
    return BSE_ERROR_PROC_PARAM_INVAL;

  type = g_type_from_name (stype);

#line 234 "bseprocedure.proc"
  
  sfi_value_set_string (out_values++, type ? bse_type_get_blurb (type) : NULL);

  return BSE_ERROR_NONE;
}

/* --- bse-type-authors --- */
static void
bse_type_authors_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 240 "bseprocedure.proc"
 {
#line 242 "bseprocedure.proc"
  *(in_pspecs++)    = sfi_pspec_string ("type", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("string", NULL, NULL, NULL, SFI_PARAM_STANDARD);
#line 244 "bseprocedure.proc"
}  }
static BseErrorType
#line 244 "bseprocedure.proc"
bse_type_authors_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 247 "bseprocedure.proc"
{
#line 248 "bseprocedure.proc"
  
  gchar *stype = sfi_value_get_string (in_values++);
  GType type;

#line 252 "bseprocedure.proc"
  
  if (!stype)
    return BSE_ERROR_PROC_PARAM_INVAL;

  type = g_type_from_name (stype);

#line 258 "bseprocedure.proc"
  
  sfi_value_set_string (out_values++, type ? bse_type_get_authors (type) : NULL);

  return BSE_ERROR_NONE;
}

/* --- bse-type-license --- */
static void
bse_type_license_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 264 "bseprocedure.proc"
 {
#line 266 "bseprocedure.proc"
  *(in_pspecs++)    = sfi_pspec_string ("type", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("string", NULL, NULL, NULL, SFI_PARAM_STANDARD);
#line 268 "bseprocedure.proc"
}  }
static BseErrorType
#line 268 "bseprocedure.proc"
bse_type_license_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 271 "bseprocedure.proc"
{
#line 272 "bseprocedure.proc"
  
  gchar *stype = sfi_value_get_string (in_values++);
  GType type;

#line 276 "bseprocedure.proc"
  
  if (!stype)
    return BSE_ERROR_PROC_PARAM_INVAL;

  type = g_type_from_name (stype);

#line 282 "bseprocedure.proc"
  
  sfi_value_set_string (out_values++, type ? bse_type_get_license (type) : NULL);

  return BSE_ERROR_NONE;
}

static gdouble
str2num (const gchar *str,
         guint        nth)
{
  gchar *num_any = ".0123456789", *num_first = num_any + 1;
  while (nth--)
    {
#line 295 "bseprocedure.proc"
      
      if (*str && strchr (num_first, *str))
        do
          str++;
        while (*str && strchr (num_any, *str));
#line 300 "bseprocedure.proc"
      
      while (*str && !strchr (num_first, *str))
        str++;
      if (!*str)
#line 304 "bseprocedure.proc"
        return 0;       
    }
  if (strchr (num_first, *str))
    return g_strtod (str, NULL);
#line 308 "bseprocedure.proc"
  return 0; 
}

/* --- bse-string-extract-number --- */
static void
bse_string_extract_number_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 311 "bseprocedure.proc"
 {
#line 313 "bseprocedure.proc"
  *(in_pspecs++)    = sfi_pspec_string ("string", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("format", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_real ("aux_base", NULL, NULL, 0, -SFI_MAXNUM, SFI_MAXNUM, 0, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_real ("dflt", NULL, NULL, 0, -SFI_MAXNUM, SFI_MAXNUM, 0, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_real ("number", NULL, NULL, 0, -SFI_MAXNUM, SFI_MAXNUM, 0, SFI_PARAM_STANDARD);
#line 318 "bseprocedure.proc"
}  }
static BseErrorType
#line 318 "bseprocedure.proc"
bse_string_extract_number_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 321 "bseprocedure.proc"
{
#line 322 "bseprocedure.proc"
  
  gchar *string   = sfi_value_get_string (in_values++);
  gchar *format   = sfi_value_get_string (in_values++);
  SfiReal aux_base = sfi_value_get_real (in_values++);
  SfiReal dflt     = sfi_value_get_real (in_values++);
  SfiReal number = dflt;

  if (string)
    {
      if (format)
        {
          gchar *base, *ep = NULL;
          switch (*format)
            {
              glong l;
            case '#':
              number = str2num (++format, 0);
              break;
            case 'n':
              l = strtol (++format, &ep, 10);
              number = str2num (string, l);
              break;
            case 'b':
              l = strtol (++format, &ep, 10);
              base = g_path_get_basename (string);
              number = str2num  (base ? base : string, l);
              g_free (base);
              break;
            case 'c':
              format++;
              number = aux_base;
              if (*format == '*')
                {
                  gdouble factor = g_strtod (++format, &ep);
                  number *= factor;
                }
              else
                ep = (char*) format;
              break;
            default:
#line 362 "bseprocedure.proc"
              
              number = 0;
              break;
            }
          if (ep && *ep)
            {
#line 368 "bseprocedure.proc"
              if (*ep == 'm')       
                number = bse_temp_freq (BSE_CONFIG (kammer_freq),
                                        number - BSE_CONFIG (midi_kammer_note));
#line 371 "bseprocedure.proc"
              else 
                number = 0;
            }
        }
      else
        number = str2num (string, 0);
    }
  sfi_value_set_real (out_values++, number);
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_bse_note_to_freq__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the frequency of a certain note.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 31;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_note_to_freq = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "bse-note-to-freq", 
    NULL,
    "/Proc/Note to Freq",
    NULL,
    __enode_bse_note_to_freq__fill_strings,
  },
  0, bse_note_to_freq_setup, bse_note_to_freq_exec, 
};
static void
__enode_bse_note_from_freq__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the note of a certain frequency.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 65;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_note_from_freq = {
  { (BseExportNode*) &__enode_bse_note_to_freq, BSE_EXPORT_NODE_PROC,
    "bse-note-from-freq", 
    NULL,
    "/Proc/Note from Freq",
    NULL,
    __enode_bse_note_from_freq__fill_strings,
  },
  0, bse_note_from_freq_setup, bse_note_from_freq_exec, 
};
static void
__enode_bse_note_describe__fill_strings (BseExportStrings *es)
{
  es->blurb = "Describe a note, providing information about its octave, semitone, frequency, etc.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 87;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_note_describe = {
  { (BseExportNode*) &__enode_bse_note_from_freq, BSE_EXPORT_NODE_PROC,
    "bse-note-describe", 
    NULL,
    "/Proc/Describe Note",
    NULL,
    __enode_bse_note_describe__fill_strings,
  },
  0, bse_note_describe_setup, bse_note_describe_exec, 
};
static void
__enode_bse_note_describe_from_freq__fill_strings (BseExportStrings *es)
{
  es->blurb = "Describe a note, given its frequency.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 111;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_note_describe_from_freq = {
  { (BseExportNode*) &__enode_bse_note_describe, BSE_EXPORT_NODE_PROC,
    "bse-note-describe-from-freq", 
    NULL,
    "/Proc/Describe Note From Freq",
    NULL,
    __enode_bse_note_describe_from_freq__fill_strings,
  },
  0, bse_note_describe_from_freq_setup, bse_note_describe_from_freq_exec, 
};
static void
__enode_bse_note_from_string__fill_strings (BseExportStrings *es)
{
  es->blurb = "Describe a note, given its name and octave offset.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 138;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_note_from_string = {
  { (BseExportNode*) &__enode_bse_note_describe_from_freq, BSE_EXPORT_NODE_PROC,
    "bse-note-from-string", 
    NULL,
    "/Proc/Note From String",
    NULL,
    __enode_bse_note_from_string__fill_strings,
  },
  0, bse_note_from_string_setup, bse_note_from_string_exec, 
};
static void
__enode_bse_note_construct__fill_strings (BseExportStrings *es)
{
  es->blurb = "Describe a note, given its semitone, octave and fine tune.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 163;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_note_construct = {
  { (BseExportNode*) &__enode_bse_note_from_string, BSE_EXPORT_NODE_PROC,
    "bse-note-construct", 
    NULL,
    "/Proc/Note Construction",
    NULL,
    __enode_bse_note_construct__fill_strings,
  },
  0, bse_note_construct_setup, bse_note_construct_exec, 
};
static void
__enode_bse_type_options__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the options of a specific type.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 193;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_type_options = {
  { (BseExportNode*) &__enode_bse_note_construct, BSE_EXPORT_NODE_PROC,
    "bse-type-options", 
    NULL,
    "/Proc/Type Options",
    NULL,
    __enode_bse_type_options__fill_strings,
  },
  0, bse_type_options_setup, bse_type_options_exec, 
};
static void
__enode_bse_type_blurb__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the description of a specific type.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 217;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_type_blurb = {
  { (BseExportNode*) &__enode_bse_type_options, BSE_EXPORT_NODE_PROC,
    "bse-type-blurb", 
    NULL,
    "/Proc/Type Blurb",
    NULL,
    __enode_bse_type_blurb__fill_strings,
  },
  0, bse_type_blurb_setup, bse_type_blurb_exec, 
};
static void
__enode_bse_type_authors__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the authors who implemented a specific type.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 241;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_type_authors = {
  { (BseExportNode*) &__enode_bse_type_blurb, BSE_EXPORT_NODE_PROC,
    "bse-type-authors", 
    NULL,
    "/Proc/Type Authors",
    NULL,
    __enode_bse_type_authors__fill_strings,
  },
  0, bse_type_authors_setup, bse_type_authors_exec, 
};
static void
__enode_bse_type_license__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the license of a type impementation.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 265;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_type_license = {
  { (BseExportNode*) &__enode_bse_type_authors, BSE_EXPORT_NODE_PROC,
    "bse-type-license", 
    NULL,
    "/Proc/Type License",
    NULL,
    __enode_bse_type_license__fill_strings,
  },
  0, bse_type_license_setup, bse_type_license_exec, 
};
static void
__enode_bse_string_extract_number__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve numbers from a string.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 312;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_string_extract_number = {
  { (BseExportNode*) &__enode_bse_type_license, BSE_EXPORT_NODE_PROC,
    "bse-string-extract-number", 
    NULL,
    "/Proc/String Extract Number",
    NULL,
    __enode_bse_string_extract_number__fill_strings,
  },
  0, bse_string_extract_number_setup, bse_string_extract_number_exec, 
};
BseExportNode* bse__builtin_init_bseprocedure_genprc_c (void);
BseExportNode* bse__builtin_init_bseprocedure_genprc_c (void)
{
  return (BseExportNode*) &__enode_bse_string_extract_number;
}

/*
 * Generated data ends here
 */
