/***************************************************************************
                         -- themes.h --
                         -------------------
    begin                : 2001-09-01
    copyright            : (C) 2001 - 2002
    authors              : Jason Kasper (vanRijn)
                         : Ben Jansens (xOr)
    URL                  : http://bbconf.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 // E_O_H_VR
#ifndef __THEMES_H
#define __THEMES_H

#include "tb_menu.h"
#include "tb_misc.h"
#include "tb_window.h"
#include "tb_toolbar.h"
#include "tb_main.h"

#include "tbwidg_common.h"

#include "plugin.h"
#include <qdict.h>

class themes : public Plugin {
public:
	themes(QObject *parent = 0, const char *n = 0, const QDict<QString> = 0);
public slots:
	void load();
	bool save();
private slots:
	void open_new(const QString);
	void save_as(const QString);
private:
	ToolboxWindow *widget_window;
	ToolboxMenu *widget_menu;
	ToolboxMisc *widget_misc;
	ToolboxToolbar *widget_toolbar;
	ToolboxMain *widget_main;

	void load_widget(QString s1, QString s2, TWBasic* ptr);
	void load_widget(QString s1, QString s2, TWPicColor* ptr);
	void load_widget(QString s1, QString s2, TWText* ptr);
	void load_widget(QString s1, QString s2, TWTextSelect* ptr);

	void save_widget(QString s, TWBasic* ptr);
	void save_widget(QString s, TWPicColor* ptr);
	void save_widget(QString s, TWText* ptr);
	void save_widget(QString s, TWTextSelect* ptr);

	void load_misc();
	void save_misc();
	void load_menu();
	void save_menu();
	void load_window();
	void save_window();
	void load_toolbar();
	void save_toolbar();
};

#endif // __THEMES_H
