/***************************************************************************
                         -- tbwidg_textsel.h --
                         -------------------
    begin                : 2001-09-01
    copyright            : (C) 2001 - 2002
    authors              : Jason Kasper (vanRijn)
                         : Ben Jansens (xOr)
    URL                  : http://bbconf.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 // E_O_H_VR
#ifndef TWTEXTSELECT_H
#define TWTEXTSELECT_H
#include "tbwidg_textsel_base.h"
#include "tbwidg_common.h"

class TWTextSelect : public TWTextSelectBase
{ 
	Q_OBJECT

public:
	TWTextSelect( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
	~TWTextSelect();

	// in order of layout....
	void setTextureHeight( int i)    { texture_height->setCurrentItem( i ); } ;
	void setColor( QColor c )        { color->setColor( c ); } ;
	void setColorTo( QColor c )      { color_to->setColor( c ); } ;
	void setTextColor( QColor c )    { textcolor->setColor( c ); } ;

	void setTexture( int i )         { texture_type->setCurrentItem( i ); } ;
	void setInterlaced( bool b )     { interlaced->setChecked( b ); } ;
	void setGradient( int i)         { gradient->setCurrentItem( i ); } ;
	void setBevel( int i )           { bevel->setCurrentItem( i ); } ;

	void setFont	( QString f )    { fontselect->setFont( f ); } ;
	void setJustify	( int j )        { fontselect->setJustify( j ); } ;

	QString getFullTexture();	// should be the only one we need.
	void setFullTexture(QString&);	// should be the only one we need.
	QString getColorString() const { return color->getColorString(); } ;
	QString getColorToString() const { return color_to->getColorString(); } ;
	QString getTextColorString() const { return textcolor->getColorString(); } ;
	QString	getFont() const { return fontselect->getFontString(); } ;
	QString	getJustify() { return fontselect->getJustify(); } ;

signals:
	void changed();

protected slots:
	void modified();
	void texture_changed(const QString&);

private:
	QString getTextureHeight() const { return texture_height->currentText(); } ;
	QString	getBevel() const         { return bevel->currentText(); } ;
	QString	getTexture() const       { return texture_type->currentText(); } ;
	QString getGradient() const      { return gradient->currentText(); } ;
	bool	getInterlaced() const    { return interlaced->isChecked(); } ;

};

#endif // TWTEXTSELECT_H
