/***************************************************************************
                         -- vr_filepreview.h --
                         -------------------
    begin                : 2001-09-01
    copyright            : (C) 2001 - 2002
    authors              : Jason Kasper (vanRijn)
                         : Ben Jansens (xOr)
    URL                  : http://bbconf.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 // E_O_H_VR
#ifndef __VRPREVIEW_H
#define __VRPREVIEW_H

#include "qlabel.h"
#include "qfiledialog.h"
#include "qtextstream.h"

#include "qpixmap.h"

class MyPreview : public QLabel, public QFilePreview
{
public:
	MyPreview( QWidget *parent=0 ) : QLabel( parent ) {
		setMinimumSize(100,100);
		setFrameStyle( QFrame::Panel | QFrame::Sunken );
		setBackgroundMode( PaletteBase );
		setScaledContents( true );
	}         

	void previewUrl( const QUrl &u )
	{
		QString path = u.path();
		QPixmap pix( path );
		pix.setOptimization( QPixmap::MemoryOptim );

		if ( pix.isNull() ) {
			QFile f(path);

			if (!f.open(IO_ReadOnly)) {
				setText( "" );
				return;
			}

			QTextStream stream(&f);	
			stream.setEncoding(QTextStream::Latin1);
			QString sDisplay;

			int i=0;
			while (!stream.eof() && i< 20) {
				sDisplay += stream.readLine() + "\n";
				i++;
			}

			f.close();

			if (sDisplay.length() && sDisplay.length() < 1000) {
				setAlignment( int( QLabel::AlignLeft ) );
				setAlignment( int( QLabel::AlignTop ) );
				setFont( QFont ("Helvetica", 8));
				setText(sDisplay);
			} else {
				setAlignment( int( QLabel::AlignCenter ) );
				setText( "" );
			}
		} else {
			setPixmap( pix );
		}

		repaint( FALSE );
	
	}
};

#endif
