/*
 * This file was hacked mercilessly by vanRijn in order to just be able to
 * use the KKeyButton class *sheesh*.  All other code was removed, and
 * aside from some small changes to remove kde dependencies on
 * kde-stuffies, not much has changed here....
 *
 * Okay, I lied.  Some things have changed. xOr and I have replaced Qt's
 * grabKeyboard and grabMouse with native X calls due to us not living
 * under the umbrella of a kapplication.  Umm, and some other stuff too...
*/

/* This file is part of the KDE libraries
    Copyright (C) 1998 Mark Donohoe <donohoe@kde.org>
    Copyright (C) 1997 Nicolas Hadacek <hadacek@via.ecp.fr>
    Copyright (C) 1998 Matthias Ettrich <ettrich@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include <qkeycode.h>
#include <qpainter.h>
#include <qapplication.h>
#include <qdrawutil.h>

#include <qlabel.h>
#include <iostream.h>

#include "my_kaccel.h"
#include "my_kkeybutton.h"

#define XK_XKB_KEYS
#define XK_MISCELLANY
#include <X11/Xlib.h>	// For x11Event()
#include <X11/keysymdef.h> // For XK_...
#include <X11/cursorfont.h> // for XGrabPointer

#ifdef KeyPress
const int XFocusOut = FocusOut;
const int XFocusIn = FocusIn;
const int XKeyPress = KeyPress;
const int XKeyRelease = KeyRelease;
#undef KeyRelease
#undef KeyPress
#undef FocusOut
#undef FocusIn
#endif

// HACK: for getting around some of Qt's lack of Meta support
enum { QT_META_MOD = Qt::ALT << 1 };	// Supply Meta bit where Qt left it out.
//bool KKeyChooserPrivate::g_bMetaPressed = false;

/***********************************************************************/
/* KKeyButton                                                          */
/*                                                                     */
/* Added by Mark Donohoe <donohoe@kde.org>                             */
/*                                                                     */
/***********************************************************************/

KKeyButton::KKeyButton(QWidget *parent, const char *name)
  : QPushButton( parent, name )
{
  setFocusPolicy( QWidget::StrongFocus );
  editing = false;
  connect( this, SIGNAL(clicked()), this, SLOT(captureKey()) );
  // qApp->installX11EventFilter( this );	// Allow button to capture X Key Events.
  setKey( 0 );
}

KKeyButton::~KKeyButton ()
{
	if( editing )
		captureKey( false );
}

void KKeyButton::setEnabled(bool enab)
{
	QPushButton::setEnabled(enab);
}

void KKeyButton::setKey( uint _key )
{
	key = _key;
	QString keyStr = KAccel::keyToString( key, false );
	setText( keyStr.isEmpty() ? tr("None") : keyStr );
}

void KKeyButton::setText( const QString& text )
{
    QPushButton::setText( text );
    setFixedSize( sizeHint().width()+12, sizeHint().height()+8 );
}

void KKeyButton::captureKey( bool bCapture )
{
	editing = bCapture;
	if( editing == true ) {
		setFocus();
		XGrabKeyboard(QPaintDevice::x11AppDisplay(), winId(), false, GrabModeAsync, GrabModeAsync,
				CurrentTime);
		XGrabPointer(QPaintDevice::x11AppDisplay(), winId(), false,
				(ButtonPressMask|ButtonReleaseMask), GrabModeAsync, GrabModeAsync,
				None, XCreateFontCursor(QPaintDevice::x11AppDisplay(), XC_X_cursor), CurrentTime);
	} else {
		XUngrabPointer(QPaintDevice::x11AppDisplay(), CurrentTime);
		XUngrabKeyboard(QPaintDevice::x11AppDisplay(), CurrentTime);
	}
	repaint();
}

void KKeyButton::captureKey()
{
	captureKey( true );
}

bool KKeyButton::x11Event( XEvent *pEvent )
{
	if( editing ) {
		//qDebug(125) << "x11Event: type: " << pEvent->type << " window: " << pEvent->xany.window << endl;
		switch( pEvent->type ) {
			case XKeyPress:
			case XKeyRelease:
				keyPressEventX( pEvent );
				return true;
			case ButtonPress:
				captureKey( false );
				setKey( key );
				return true;
		}
	}
	return QWidget::x11Event( pEvent );
}

void KKeyButton::keyPressEventX( XEvent *pEvent )
{
	uint keyModX = 0, keySymX;
	KAccel::keyEventXToKeyX( pEvent, 0, &keySymX, 0 );

	//kdDebug(125) << QString( "keycode: 0x%1 state: 0x%2\n" )
	//			.arg( pEvent->xkey.keycode, 0, 16 ).arg( pEvent->xkey.state, 0, 16 );

	switch( keySymX ) {
		// Don't allow setting a modifier key as an accelerator.
		// Also, don't release the focus yet.  We'll wait until
		//  we get a 'normal' key.
		case XK_Shift_L:   case XK_Shift_R:	keyModX = KAccel::keyModXShift(); break;
		case XK_Control_L: case XK_Control_R:	keyModX = KAccel::keyModXCtrl(); break;
		case XK_Alt_L:     case XK_Alt_R:	keyModX = KAccel::keyModXAlt(); break;
		case XK_Meta_L:    case XK_Meta_R:	keyModX = KAccel::keyModXMeta(); break;
		case XK_Super_L:   case XK_Super_R:
		case XK_Hyper_L:   case XK_Hyper_R:
		case XK_Mode_switch:
			break;
		default:
			uint keyCombQt = KAccel::keyEventXToKeyQt( pEvent );
			if( keyCombQt && keyCombQt != Qt::Key_unknown ) {
				captureKey( false );
				// The parent must decide whether this is a valid
				//  key, and if so, call setKey(uint) with the new value.
				emit capturedKey( keyCombQt );
				setKey( key );
			}
			return;
	}

	if( pEvent->type == XKeyPress )
		keyModX |= pEvent->xkey.state;
	else
		keyModX = pEvent->xkey.state & ~keyModX;

	QString keyModStr;
	if( keyModX & KAccel::keyModXMeta() )	keyModStr += tr("Meta") + "+";
	if( keyModX & KAccel::keyModXAlt() )	keyModStr += tr("Alt") + "+";
	if( keyModX & KAccel::keyModXCtrl() )	keyModStr += tr("Ctrl") + "+";
	if( keyModX & KAccel::keyModXShift() )	keyModStr += tr("Shift") + "+";

	// Display currently selected modifiers, or redisplay old key.
	if( !keyModStr.isEmpty() )
		setText( keyModStr );
	else
		setKey( key );
}

void KKeyButton::drawButton( QPainter *painter )
{
  QPointArray a( 4 );
  a.setPoint( 0, 0, 0) ;
  a.setPoint( 1, width(), 0 );
  a.setPoint( 2, 0, height() );
  a.setPoint( 3, 0, 0 );

  QRegion r1( a );
  painter->setClipRegion( r1 );
  painter->setBrush( backgroundColor().light() );
  painter->drawRoundRect( 0, 0, width(), height(), 20, 20);

  a.setPoint( 0, width(), height() );
  a.setPoint( 1, width(), 0 );
  a.setPoint( 2, 0, height() );
  a.setPoint( 3, width(), height() );

  QRegion r2( a );
  painter->setClipRegion( r2 );
  painter->setBrush( backgroundColor().dark() );
  painter->drawRoundRect( 0, 0, width(), height(), 20, 20 );

  painter->setClipping( false );
  if( width() > 12 && height() > 8 )
    qDrawShadePanel( painter, 6, 4, width() - 12, height() - 8,
                     colorGroup(), true, 1, 0L );
  if ( editing )
  {
    painter->setPen( colorGroup().base() );
    painter->setBrush( colorGroup().base() );
  }
  else
  {
    painter->setPen( backgroundColor() );
    painter->setBrush( backgroundColor() );
  }
  if( width() > 14 && height() > 10 )
    painter->drawRect( 7, 5, width() - 14, height() - 10 );

  drawButtonLabel( painter );

  painter->setPen( colorGroup().text() );
  painter->setBrush( NoBrush );
  if( hasFocus() || editing )
  {
    if( width() > 16 && height() > 12 )
      painter->drawRect( 8, 6, width() - 16, height() - 12 );
  }

}
