/***************************************************************************
                         -- keyconf.cc --
                         -------------------
    begin                : 2001-09-01
    copyright            : (C) 2001 - 2002
    authors              : Jason Kasper (vanRijn)
                         : Ben Jansens (xOr)
    URL                  : http://bbconf.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 // E_O_H_VR
#include "keyconf.h"

#include <iostream>
#include <stdlib.h>

#include <qlistview.h>
#include <qlineedit.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qmessagebox.h>

#include "addcommand.h"
#include "editcommand.h"
#include "my_kkeybutton.h"
#include "my_kaccel.h"

/* 
 *  Constructs a KeysConf which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
KeysConf::KeysConf( QWidget* parent,  const char* name, WFlags fl )
    : KeysConfBase( parent, name, fl )
{
	listview->setSorting(-1);
	// get the listview item for the "Command Keybindings" item, and for the
	// "Click here to add..." item
	QListViewItem *p = listview->firstChild();
	while (p) {
		if ( p->text(0).contains( "Command Keybindings" ) ) {
			p = p->firstChild();
			while (p) {
				if ( p->text(0).contains( "Click here to add a new command" ) ) {
					CommandAddItem = p;
					break;
				}
				p = p->nextSibling();
			}
			break;
		}
		p = p->nextSibling();
	}

	listview->setColumnWidthMode(0,QListView::Manual);
	listview->setColumnWidthMode(1,QListView::Maximum);

	// set columns 2 & 3 to zero width, manual widthmode so we
	// hide our internal bbkeys translations from view
	listview->setColumnWidth(2,0);
	listview->setColumnWidthMode(2,QListView::Manual);
	listview->setColumnWidth(3,0);
	listview->setColumnWidthMode(3,QListView::Manual);

	grabbing = false;
}

/*  
 *  Destroys the object and frees any allocated resources
 */
KeysConf::~KeysConf()
{
}

void KeysConf::populateList(QDict<QString> *dict) {
	// iterate through the listview and populate the keybindings column
	// from the dictionary....

	QListViewItemIterator it( listview );

	for ( ; it.current(); ++it ) {
		QString bbAction = it.current()->text(2);

		if ( bbAction.length() ) {
			QString* sDict = dict->find(bbAction);
			if ( sDict && sDict->length() )
				it.current()->setText( 1, sDict->latin1() );
			else
				it.current()->setText( 1, "" );
		}
	}

	// clear off any existing ExecCommand's
	QListViewItem *n = CommandAddItem;
	while ((n = CommandAddItem->nextSibling()) != NULL) delete n;

	// now load in any ExecCommands we picked up from our rc-file
	n = CommandAddItem;
	QString* sDict;
	QList<QString> dictList;
	while ((sDict = dict->find("ExecCommand"))) {
		n = new QListViewItem(CommandAddItem->parent(), n);
		int sPipe = sDict->find("|");
		int sLen = sDict->length() - sPipe;
		n->setText( 0, sDict->mid(sPipe +1 , sLen) );
		n->setText( 1, sDict->mid(0,sPipe) );
		n->setText( 2, "ExecCommand" );
		// pop the last one off the stack, and put it in a temporary list
		dictList.insert(0, dict->take("ExecCommand"));
	}
	// readd the ExecCommands that were removed
	QListIterator<QString> it_list(dictList);
	for (; it_list.current(); ++it_list)
		dict->insert("ExecCommand", it_list.current());

	// reselect the item that is selected, this is to reset the option buttons
	// and the grab button at the bottom when reset is pressed
	QListViewItem *sel = listview->selectedItem();
	if (sel) itemSelected(sel);
}

/* 
 * protected slot
 */
void KeysConf::itemSelected(QListViewItem *selected) {

		if (selected == CommandAddItem) {
			keygroup->setEnabled(false);
		} else if ( selected->text(2) ) {
			keygroup->setEnabled(true);
			if (selected->text(1).length()) {
				opt_custom_key->setChecked(true);
				bKgrab->setEnabled(true);
				bKgrab->setKey( KAccel::stringToKey(selected->text(1)) );
			} else {
				opt_nokey->setChecked(true);
				bKgrab->setEnabled(false);
				bKgrab->setKey( 0 );
			}
		} else {
			keygroup->setEnabled(false);
		}

}

void KeysConf::itemClicked(QListViewItem *selected) {

		if (selected == CommandAddItem) {
			keygroup->setEnabled(false);
			AddCommand *dlg = new AddCommand(this, "AddCommandDialog", true);
			dlg->exec();
			if (dlg->result() == QDialog::Accepted && 
		  	dlg->LineEdit1->text().length() ) {
				// add the new item to the bottom of the children of 'CommandAddItem'
				QListViewItem *i = CommandAddItem;
				while(i->nextSibling())
					i = i->nextSibling();
				i = new QListViewItem(CommandAddItem->parent(), i);
				i->setText(0, dlg->LineEdit1->text());
				i->setText(2, "ExecCommand" );
				listview->ensureItemVisible( i );
				listview->setCurrentItem( i );
				keygroup->setEnabled(true);
				changed();
			}
			delete dlg;
		} 

}

void KeysConf::itemDoubleClicked(QListViewItem *clicked) {
	if (!CommandAddItem) return;

	// double clicking only applies to the added commands, so if 'clicked' isnt
	// one of them, don't do anything
	QListViewItem *p = CommandAddItem;
	while ( (p = p->nextSibling() ) )
		if (p == clicked) {
			EditCommand *dlg = new EditCommand(this, "EditCommandDialog", true);
			dlg->LineEdit1->setText(clicked->text(0));
			dlg->exec();
			if (dlg->result() == QDialog::Accepted &&
			  dlg->LineEdit1->text().length() ) {
				clicked->setText(0, dlg->LineEdit1->text()); // change the command
				clicked->setText(2, "ExecCommand" );
				changed();
			}
			else if (dlg->deleteCommand()) {
				delete clicked;
				changed();
			}				
		}
}

void KeysConf::modified() {
	changed();
}

void KeysConf::opt_nokeys_checked() {
	listview->currentItem()->setText(1,"");
	changed();
	bKgrab->setKey( 0 );
	bKgrab->setEnabled(false);
}

void KeysConf::opt_customkey_checked() {
	bKgrab->setEnabled(true);
	bKgrab->captureKey();
}

void KeysConf::capturedKey(uint key) {

	QString s = KAccel::keyToString( key, false );

	if( ! s.isEmpty() ) {
		setKey( key );
	}
}

void KeysConf::setKey( int keyCode ) {

	QListViewItem *item = listview->currentItem();
	QString combo = KAccel::keyToString( keyCode, false );

	/*
	if( keyCode < 0x1000  ) {
		QString s = tr( 	"In order to use the '%1' key as a shortcut,\n"
				"it must be combined with the\n"
				"Meta, Alt, Ctrl, and/or Shift keys." ).arg(QChar(keyCode));
		QMessageBox::warning( this, tr("Invalid Shortcut Key") , s );
	return;
	}
	*/

	if ( ! isKeyPresent( keyCode, true) ) {
		item->setText(1, combo );
		bKgrab->setKey( keyCode );
		changed();
	}

}

bool KeysConf::isKeyPresent( int kcode, bool warnuser ) {
  
	if ( !listview )
		return 0;     // Create the list

	QString keyName = KAccel::keyToString( kcode, false );

	QListViewItemIterator it( listview );
	// iterate through all items of the listview
	for ( ; it.current(); ++it ) {
		if ( it.current()->text(1) == keyName && 
			it.current() != listview->currentItem() ) {
			if (warnuser) {
				QString str =
					tr("Ouch! The %1 key combination has already "
					"been allocated\n"
					"to the %2 action.\n"
					"\n"
					"Please choose a unique key combination.").
					arg(it.current()->text(1)).arg(it.current()->text(0));
				QMessageBox::warning( this, tr("Whoopsie! Key conflict.") , str );
			}
			return true;
		}
	}

	return false;

}

