/***************************************************************************
                         -- main.cc --
                         -------------------
    begin                : 2001-09-01
    copyright            : (C) 2001 - 2002
    authors              : Jason Kasper (vanRijn)
                         : Ben Jansens (xOr)
    URL                  : http://bbconf.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 // E_O_H_VR
#include <qapplication.h>
#include <qlistview.h>
#include <qdir.h>
#include <qstringlist.h>
#include <qdict.h>
#include <dlfcn.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "win.h"
#include "plugin.h"

#include "../config.h"

void Usage()
{
	fprintf(stderr, "\n%s version %s \n", PACKAGE, VERSION);
	fprintf(stderr, "Usage: %s [options]\n", PACKAGE);
	fprintf(stderr, "Options:\n"
	" -v  or --version        Display version number\n"
	" -h  or --help           Print this help page\n"
	"\n"
	" -s  or --start-plugin   Which plugin to start working with first\n"
	"        - note: bbconf looks for the 'description' of the plugin, such \n"
	"          as 'key bindings' or 'menu editor' (case insensitive) for\n"
	"          this option\n"
	"        - example: bbconf -s 'key bindings'\n"
	"\n"
	" -p  or --plugin-dir     Directory for bbconf to find its plugins in\n"
	"        - example: bbconf -p /home/dude/.studly/plugins\n"
	"\n"
	" -a  or --args           Additional arguments to pass to any of bbconf's\n"
	"          plugins. The entire string following '-a' must be enclosed in\n"
	"          quotes.  Multiple plugins may be passed arguments on the command\n"
	"          line.  Currently 'loadfile=' is the only supported argument for\n"
	"          bbconf's plugins.  Arguments *must* be given in the following form...\n"
	"\n"
	"          plugin_without_the_.so_suffix:directive=whatever,[repeat if desired]\n"
	"\n"
	"        - example:   bbconf -a 'libkeybindings:loadfile=/home/me/.bbox/keys, \\\n"
	"                               libthemes:loadfile=/home/me/.blackbox/cooltheme'\n\n");
	
}

QDict<QString> getArgs(QString *file, QString inargs) {

	QDict<QString> args;

	QStringList list = QStringList::split( "," ,inargs.latin1(), false);

	// iterate through each comma-separated argv** bbconf is passed and
	// see what args we were passed only if the _plugin matches our
	// incoming filename
	for ( QStringList::Iterator it = list.begin(); it != list.end(); ++it ) {
		QString line = (*it).latin1();
		int pos=line.find(":");
		QString _plugin = line.left( pos ).stripWhiteSpace();
		QString _args = line.right( line.length() - pos -1).stripWhiteSpace();
		pos = _args.find("=");
		if (pos > 0) {
			QString _key  = _args.left( pos ).stripWhiteSpace();
			QString *_val  = 
				new QString(_args.right( _args.length() -pos -1).stripWhiteSpace());

			if ( file->contains( _plugin , false ) ) {
				args.replace( _key, _val );
			}
		}
	}

	return args;

}

plugin *getPluginClass(QString *file, QString args) {
	typedef void *(*factory)(QDict<QString>);
	const char *error;

	void *hndl = dlopen(file->latin1(), RTLD_LAZY);
	if (hndl == NULL) {
		fprintf(stderr, "unable to open %s\n", file->latin1());
		return NULL;
	}
	factory mkr = (factory) dlsym(hndl, "maker");
	if ((error = dlerror()) != NULL) {
		factory mkr = (factory) dlsym(hndl, "_maker");
		if ((error = dlerror()) != NULL) {
			fprintf(stderr, "unable to create plugin from %s\n", file->latin1());
			return NULL;
		}
	}

	QDict<QString> params=getArgs(file, args);

	plugin *ret = (plugin *) mkr(params);

	// We should close the dynamic link but under linux this makes Qt crash
	//dlclose(hndl);
	return ret;	
}

void addPluginDir(const char* dirname, QDict<QString> *plugindict) {
	QDir dir(dirname);
	if ( !dir.exists() )
		return;

	dir.setFilter(QDir::Files);
	const QFileInfoList *list = dir.entryInfoList("*.so");
	if (list) {
		QFileInfoListIterator it(*list);
		QFileInfo *fi;
		while ( (fi=it.current()) ) {
			QString name = fi->fileName().data();
			QString *absname = new QString(dir.absFilePath(fi->fileName().data()));
			plugindict->replace(name, absname);
			++it;
		}
	}
}

int main( int argc, char **argv )
{
	
	QString start_plugin;
	QString local_plugin_dir;
	QString plugin_args;

	// check command-line args before we do anything
	for(int i=1; i<argc; i++) {	
		if ((!strcmp(argv[i], "-v")) || (!strcmp(argv[i], "--version"))) {
			fprintf(stderr, " %s -- version %s\n", PACKAGE, VERSION);
			exit(2);
		} else if ((!strcmp(argv[i], "-h")) || (!strcmp(argv[i], "--help"))) {
			Usage();
			exit(2);
		} else if ((!strcmp(argv[i], "-s")) || (!strcmp(argv[i], "--start-plugin"))) {
			if (++i == argc) {
				Usage(); exit(2);
			}
			start_plugin = argv[i];
		} else if ((!strcmp(argv[i], "-p")) || (!strcmp(argv[i], "--plugin-dir"))) {
			if (++i == argc) {
				Usage(); exit(2);
			}
			local_plugin_dir = argv[i];
		} else if ((!strcmp(argv[i], "-a")) || (!strcmp(argv[i], "--args"))) {
			if (++i == argc) {
				Usage(); exit(2);
			}
			plugin_args = argv[i];
		};

	}

	QApplication app( argc, argv );

	QList<plugin> *plugin_list = new QList<plugin>;
	{
		QDict<QString> dict;
		addPluginDir(PLUGIN_DIR, &dict);
		QString localdir(getenv("HOME"));
		localdir.append("/.bbconf");
		addPluginDir(localdir, &dict);

		QDictIterator<QString> it(dict);
		while (it.current()) {
			plugin *p = getPluginClass(it.current(), plugin_args);
			if (p)
				plugin_list->append(p);
			++it;
		}
	}

	MainWindow form;
	app.setMainWidget(&form);
	form.setPlugins(plugin_list, start_plugin);
	delete plugin_list;

	form.show();
	int ret = app.exec();

	return ret;
}
