/* dir-as-cwd.c:
 *
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/fs/file-names.h"
#include "hackerlab/fs/cwd.h"
#include "hackerlab/vu/safe.h"
#include "libfsutils/dir-as-cwd.h"



t_uchar *
directory_as_cwd (t_uchar * dir)
{
  t_uchar * answer = 0;
  int failure = directory_as_cwd_unsafe (&answer, dir);
  if (failure)
    {
      safe_printfmt (2, "Failed to get directory for : '%s', errn=%d\n", dir, failure);
    }
  return answer;
}

/**
 * \brief attempt to get the pwd from dir
 * \return 0 on success, an errn otherwise
 */
int
directory_as_cwd_unsafe (t_uchar **result, t_uchar const * dir)
{
  int here_fd;
  int errn = 0;

  here_fd = safe_open (".", O_RDONLY, 0);

  if (vu_chdir (&errn, (t_uchar *)dir) >= 0)
    {
      *result = safe_current_working_directory ();
      safe_fchdir (here_fd);
    }
  safe_close (here_fd);
  return errn;
}



/* tag: Tom Lord Fri May 30 21:47:40 2003 (dir-as-cwd.c)
 */
