/* cached-archive.h:
 *
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 * Copyright (C) 2004 Aaron Bentley
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#ifndef INCLUDE__LIBARCH__CACHED_ARCHIVE_H
#define INCLUDE__LIBARCH__CACHED_ARCHIVE_H

#include "libarch/archive.h"

extern int arch_cached_archive_connect (struct arch_archive ** a, int soft_errors);

extern t_uchar * arch_uncached_location (t_uchar const *location);

extern void arch_cached_make_archive (t_uchar * name, t_uchar * uri, t_uchar * version, t_uchar *mirror_of, int dot_listing_lossage, int signed_archive);

struct arch_cached_archive
{
  struct arch_archive arch;
  struct arch_archive *wrapped_arch;
};

extern int arch_cached_archive_protocol (t_uchar const * location);

extern t_uchar * arch_revision_query (struct arch_archive * a,
				      t_uchar const * revision, 
				      t_uchar const * extension);
extern struct arch_archive * arch_cached_archive_as_pfs(struct arch_archive * arch);
#endif

/* tag: 49b6a279-7f5f-4e49-88b5-c9861e055718 
 */

