/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id: AFPElementMapping.java 397875 2006-04-28 11:58:33Z manuel $ */

package org.apache.fop.render.pcl.extensions;

import java.util.HashMap;

import org.apache.fop.fo.ElementMapping;

/**
 * PCL-specific extensions for Apache FOP.
 */
public class PCLElementMapping extends ElementMapping {

    /** The namespace used for PCL extensions */
    public static final String NAMESPACE = "http://xmlgraphics.apache.org/fop/extensions/pcl";

    /** The usual namespace prefix used for PCL extensions */
    public static final String NAMESPACE_PREFIX = "pcl";

    /** Main constructor */
    public PCLElementMapping() {
        this.namespaceURI = NAMESPACE;
    }

    /** @see org.apache.fop.fo.ElementMapping#initialize() */
    protected void initialize() {

        if (foObjs == null) {
            foObjs = new HashMap();
            //No extension elements, yet, only attributes
        }

    }

}
