/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script.rhino;

import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.events.CustomEvent;
import org.apache.batik.script.ScriptEventWrapper;
import org.apache.batik.script.rhino.RhinoInterpreter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

class EventTargetWrapper
extends NativeJavaObject {
    protected static WeakHashMap mapOfListenerMap;
    public static final String ADD_NAME = "addEventListener";
    public static final String ADDNS_NAME = "addEventListenerNS";
    public static final String REMOVE_NAME = "removeEventListener";
    public static final String REMOVENS_NAME = "removeEventListenerNS";
    public static final String DISPATCH_NAME = "dispatchEvent";
    protected RhinoInterpreter interpreter;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$org$mozilla$javascript$Function;
    static /* synthetic */ Class class$org$mozilla$javascript$Scriptable;
    static /* synthetic */ Class class$java$lang$Object;

    EventTargetWrapper(Scriptable scriptable, EventTarget eventTarget, RhinoInterpreter rhinoInterpreter) {
        super(scriptable, (Object)eventTarget, null);
        this.interpreter = rhinoInterpreter;
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = super.get(string, scriptable);
        if (string.equals(ADD_NAME)) {
            object = new FunctionAddProxy(this.interpreter, (Function)object, this.initMap());
        } else if (string.equals(REMOVE_NAME)) {
            object = new FunctionRemoveProxy((Function)object, this.initMap());
        } else if (string.equals(ADDNS_NAME)) {
            object = new FunctionAddNSProxy(this.interpreter, (Function)object, this.initMap());
        } else if (string.equals(REMOVENS_NAME)) {
            object = new FunctionRemoveNSProxy((Function)object, this.initMap());
        } else if (string.equals(DISPATCH_NAME)) {
            object = new FunctionDispatchProxy(this.interpreter, (Function)object, this.initMap());
        }
        return object;
    }

    public Map initMap() {
        WeakHashMap weakHashMap = null;
        if (mapOfListenerMap == null) {
            mapOfListenerMap = new WeakHashMap(10);
        }
        if ((weakHashMap = (WeakHashMap)mapOfListenerMap.get(this.unwrap())) == null) {
            weakHashMap = new WeakHashMap(2);
            mapOfListenerMap.put(this.unwrap(), weakHashMap);
        }
        return weakHashMap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class FunctionDispatchProxy
    extends FunctionProxy {
        protected Map eventMap;
        protected RhinoInterpreter interpreter;

        FunctionDispatchProxy(RhinoInterpreter rhinoInterpreter, Function function, Map map) {
            super(function);
            this.eventMap = map;
            this.interpreter = rhinoInterpreter;
        }

        public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
            NativeJavaObject nativeJavaObject = (NativeJavaObject)scriptable2;
            if (objectArray[0] instanceof NativeObject) {
                ObjectCustomEvent objectCustomEvent = new ObjectCustomEvent((Scriptable)((NativeObject)objectArray[0]), this.interpreter, this.eventMap);
                this.eventMap.put(objectArray[0], new SoftReference<ObjectCustomEvent>(objectCustomEvent));
                objectArray[0] = Context.jsToJava((Object)objectArray[0], (Class)(class$org$mozilla$javascript$Scriptable == null ? (class$org$mozilla$javascript$Scriptable = EventTargetWrapper.class$("org.mozilla.javascript.Scriptable")) : class$org$mozilla$javascript$Scriptable));
                ((EventTarget)nativeJavaObject.unwrap()).dispatchEvent((Event)((Object)objectCustomEvent));
                return Undefined.instance;
            }
            return this.delegate.call(context, scriptable, scriptable2, objectArray);
        }
    }

    static class FunctionRemoveNSProxy
    extends FunctionProxy {
        protected Map listenerMap;

        FunctionRemoveNSProxy(Function function, Map map) {
            super(function);
            this.listenerMap = map;
        }

        public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
            NativeJavaObject nativeJavaObject = (NativeJavaObject)scriptable2;
            if (objectArray[2] instanceof Function) {
                SoftReference softReference = (SoftReference)this.listenerMap.get(objectArray[2]);
                if (softReference == null) {
                    return Undefined.instance;
                }
                EventListener eventListener = (EventListener)softReference.get();
                if (eventListener == null) {
                    return Undefined.instance;
                }
                Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Function == null ? (class$org$mozilla$javascript$Function = EventTargetWrapper.class$("org.mozilla.javascript.Function")) : class$org$mozilla$javascript$Function, Boolean.TYPE};
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = Context.jsToJava((Object)objectArray[i], (Class)classArray[i]);
                }
                AbstractNode abstractNode = (AbstractNode)nativeJavaObject.unwrap();
                abstractNode.removeEventListenerNS((String)objectArray[0], (String)objectArray[1], eventListener, ((Boolean)objectArray[3]).booleanValue());
                return Undefined.instance;
            }
            if (objectArray[2] instanceof NativeObject) {
                SoftReference softReference = (SoftReference)this.listenerMap.get(objectArray[2]);
                if (softReference == null) {
                    return Undefined.instance;
                }
                EventListener eventListener = (EventListener)softReference.get();
                if (eventListener == null) {
                    return Undefined.instance;
                }
                Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Scriptable == null ? (class$org$mozilla$javascript$Scriptable = EventTargetWrapper.class$("org.mozilla.javascript.Scriptable")) : class$org$mozilla$javascript$Scriptable, Boolean.TYPE};
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = Context.jsToJava((Object)objectArray[i], (Class)classArray[i]);
                }
                AbstractNode abstractNode = (AbstractNode)nativeJavaObject.unwrap();
                abstractNode.removeEventListenerNS((String)objectArray[0], (String)objectArray[1], eventListener, ((Boolean)objectArray[3]).booleanValue());
                return Undefined.instance;
            }
            return this.delegate.call(context, scriptable, scriptable2, objectArray);
        }
    }

    static class FunctionAddNSProxy
    extends FunctionProxy {
        protected Map listenerMap;
        protected RhinoInterpreter interpreter;

        FunctionAddNSProxy(RhinoInterpreter rhinoInterpreter, Function function, Map map) {
            super(function);
            this.listenerMap = map;
            this.interpreter = rhinoInterpreter;
        }

        public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
            NativeJavaObject nativeJavaObject = (NativeJavaObject)scriptable2;
            if (objectArray[2] instanceof Function) {
                FunctionEventListener functionEventListener = new FunctionEventListener((Function)objectArray[2], this.interpreter);
                this.listenerMap.put(objectArray[2], new SoftReference<FunctionEventListener>(functionEventListener));
                Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Function == null ? (class$org$mozilla$javascript$Function = EventTargetWrapper.class$("org.mozilla.javascript.Function")) : class$org$mozilla$javascript$Function, Boolean.TYPE, class$java$lang$Object == null ? (class$java$lang$Object = EventTargetWrapper.class$("java.lang.Object")) : class$java$lang$Object};
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = Context.jsToJava((Object)objectArray[i], (Class)classArray[i]);
                }
                AbstractNode abstractNode = (AbstractNode)nativeJavaObject.unwrap();
                abstractNode.addEventListenerNS((String)objectArray[0], (String)objectArray[1], (EventListener)functionEventListener, ((Boolean)objectArray[3]).booleanValue(), objectArray[4]);
                return Undefined.instance;
            }
            if (objectArray[2] instanceof NativeObject) {
                HandleEventListener handleEventListener = new HandleEventListener((Scriptable)objectArray[2], this.interpreter);
                this.listenerMap.put(objectArray[2], new SoftReference<HandleEventListener>(handleEventListener));
                Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Scriptable == null ? (class$org$mozilla$javascript$Scriptable = EventTargetWrapper.class$("org.mozilla.javascript.Scriptable")) : class$org$mozilla$javascript$Scriptable, Boolean.TYPE, class$java$lang$Object == null ? (class$java$lang$Object = EventTargetWrapper.class$("java.lang.Object")) : class$java$lang$Object};
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = Context.jsToJava((Object)objectArray[i], (Class)classArray[i]);
                }
                AbstractNode abstractNode = (AbstractNode)nativeJavaObject.unwrap();
                abstractNode.addEventListenerNS((String)objectArray[0], (String)objectArray[1], (EventListener)handleEventListener, ((Boolean)objectArray[3]).booleanValue(), objectArray[4]);
                return Undefined.instance;
            }
            return this.delegate.call(context, scriptable, scriptable2, objectArray);
        }
    }

    static class FunctionRemoveProxy
    extends FunctionProxy {
        public Map listenerMap;

        FunctionRemoveProxy(Function function, Map map) {
            super(function);
            this.listenerMap = map;
        }

        public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
            NativeJavaObject nativeJavaObject = (NativeJavaObject)scriptable2;
            if (objectArray[1] instanceof Function) {
                SoftReference softReference = (SoftReference)this.listenerMap.get(objectArray[1]);
                if (softReference == null) {
                    return Undefined.instance;
                }
                EventListener eventListener = (EventListener)softReference.get();
                if (eventListener == null) {
                    return Undefined.instance;
                }
                Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Function == null ? (class$org$mozilla$javascript$Function = EventTargetWrapper.class$("org.mozilla.javascript.Function")) : class$org$mozilla$javascript$Function, Boolean.TYPE};
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = Context.jsToJava((Object)objectArray[i], (Class)classArray[i]);
                }
                ((EventTarget)nativeJavaObject.unwrap()).removeEventListener((String)objectArray[0], eventListener, (Boolean)objectArray[2]);
                return Undefined.instance;
            }
            if (objectArray[1] instanceof NativeObject) {
                SoftReference softReference = (SoftReference)this.listenerMap.get(objectArray[1]);
                if (softReference == null) {
                    return Undefined.instance;
                }
                EventListener eventListener = (EventListener)softReference.get();
                if (eventListener == null) {
                    return Undefined.instance;
                }
                Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Scriptable == null ? (class$org$mozilla$javascript$Scriptable = EventTargetWrapper.class$("org.mozilla.javascript.Scriptable")) : class$org$mozilla$javascript$Scriptable, Boolean.TYPE};
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = Context.jsToJava((Object)objectArray[i], (Class)classArray[i]);
                }
                ((EventTarget)nativeJavaObject.unwrap()).removeEventListener((String)objectArray[0], eventListener, (Boolean)objectArray[2]);
                return Undefined.instance;
            }
            return this.delegate.call(context, scriptable, scriptable2, objectArray);
        }
    }

    static class FunctionAddProxy
    extends FunctionProxy {
        protected Map listenerMap;
        protected RhinoInterpreter interpreter;

        FunctionAddProxy(RhinoInterpreter rhinoInterpreter, Function function, Map map) {
            super(function);
            this.listenerMap = map;
            this.interpreter = rhinoInterpreter;
        }

        public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
            NativeJavaObject nativeJavaObject = (NativeJavaObject)scriptable2;
            if (objectArray[1] instanceof Function) {
                EventListener eventListener = null;
                SoftReference softReference = (SoftReference)this.listenerMap.get(objectArray[1]);
                if (softReference != null) {
                    eventListener = (EventListener)softReference.get();
                }
                if (eventListener == null) {
                    eventListener = new FunctionEventListener((Function)objectArray[1], this.interpreter);
                    this.listenerMap.put(objectArray[1], new SoftReference<EventListener>(eventListener));
                }
                Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Function == null ? (class$org$mozilla$javascript$Function = EventTargetWrapper.class$("org.mozilla.javascript.Function")) : class$org$mozilla$javascript$Function, Boolean.TYPE};
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = Context.jsToJava((Object)objectArray[i], (Class)classArray[i]);
                }
                ((EventTarget)nativeJavaObject.unwrap()).addEventListener((String)objectArray[0], eventListener, (Boolean)objectArray[2]);
                return Undefined.instance;
            }
            if (objectArray[1] instanceof NativeObject) {
                EventListener eventListener = null;
                SoftReference softReference = (SoftReference)this.listenerMap.get(objectArray[1]);
                if (softReference != null) {
                    eventListener = (EventListener)softReference.get();
                }
                if (eventListener == null) {
                    eventListener = new HandleEventListener((Scriptable)objectArray[1], this.interpreter);
                    this.listenerMap.put(objectArray[1], new SoftReference<EventListener>(eventListener));
                }
                Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Scriptable == null ? (class$org$mozilla$javascript$Scriptable = EventTargetWrapper.class$("org.mozilla.javascript.Scriptable")) : class$org$mozilla$javascript$Scriptable, Boolean.TYPE};
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = Context.jsToJava((Object)objectArray[i], (Class)classArray[i]);
                }
                ((EventTarget)nativeJavaObject.unwrap()).addEventListener((String)objectArray[0], eventListener, (Boolean)objectArray[2]);
                return Undefined.instance;
            }
            return this.delegate.call(context, scriptable, scriptable2, objectArray);
        }
    }

    static abstract class FunctionProxy
    implements Function {
        protected Function delegate;

        public FunctionProxy(Function function) {
            this.delegate = function;
        }

        public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
            return this.delegate.construct(context, scriptable, objectArray);
        }

        public String getClassName() {
            return this.delegate.getClassName();
        }

        public Object get(String string, Scriptable scriptable) {
            return this.delegate.get(string, scriptable);
        }

        public Object get(int n, Scriptable scriptable) {
            return this.delegate.get(n, scriptable);
        }

        public boolean has(String string, Scriptable scriptable) {
            return this.delegate.has(string, scriptable);
        }

        public boolean has(int n, Scriptable scriptable) {
            return this.delegate.has(n, scriptable);
        }

        public void put(String string, Scriptable scriptable, Object object) {
            this.delegate.put(string, scriptable, object);
        }

        public void put(int n, Scriptable scriptable, Object object) {
            this.delegate.put(n, scriptable, object);
        }

        public void delete(String string) {
            this.delegate.delete(string);
        }

        public void delete(int n) {
            this.delegate.delete(n);
        }

        public Scriptable getPrototype() {
            return this.delegate.getPrototype();
        }

        public void setPrototype(Scriptable scriptable) {
            this.delegate.setPrototype(scriptable);
        }

        public Scriptable getParentScope() {
            return this.delegate.getParentScope();
        }

        public void setParentScope(Scriptable scriptable) {
            this.delegate.setParentScope(scriptable);
        }

        public Object[] getIds() {
            return this.delegate.getIds();
        }

        public Object getDefaultValue(Class clazz) {
            return this.delegate.getDefaultValue(clazz);
        }

        public boolean hasInstance(Scriptable scriptable) {
            return this.delegate.hasInstance(scriptable);
        }
    }

    static class ObjectCustomEvent
    implements CustomEvent,
    ScriptEventWrapper {
        public Scriptable scriptable;
        public RhinoInterpreter interpreter;
        protected Map eventMap;

        public ObjectCustomEvent(Scriptable scriptable, RhinoInterpreter rhinoInterpreter, Map map) {
            this.scriptable = scriptable;
            this.interpreter = rhinoInterpreter;
            this.eventMap = map;
        }

        public Object getEventObject() {
            return this.scriptable;
        }

        protected Object call(String string) {
            return this.call(string, null);
        }

        protected Object call(String string, Object[] objectArray) {
            ContextAction contextAction = new ContextAction(this, string, objectArray){
                private final /* synthetic */ String val$fn;
                private final /* synthetic */ Object[] val$args;
                private final /* synthetic */ ObjectCustomEvent this$0;
                {
                    this.this$0 = objectCustomEvent;
                    this.val$fn = string;
                    this.val$args = objectArray;
                }

                public Object run(Context context) {
                    return ScriptableObject.callMethod((Scriptable)this.this$0.scriptable, (String)this.val$fn, (Object[])this.val$args);
                }
            };
            return this.interpreter.call(contextAction);
        }

        public String getType() {
            return (String)Context.jsToJava((Object)this.scriptable.get("type", this.scriptable), (Class)(class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String));
        }

        public EventTarget getTarget() {
            Object object = this.scriptable.get("target", this.scriptable);
            if (object instanceof NativeJavaObject) {
                object = ((NativeJavaObject)object).unwrap();
            }
            return (EventTarget)object;
        }

        public void setTarget(EventTarget eventTarget) {
            this.scriptable.put("target", this.scriptable, (Object)Context.toObject((Object)eventTarget, (Scriptable)this.scriptable));
        }

        public EventTarget getCurrentTarget() {
            Object object = this.scriptable.get("currentTarget", this.scriptable);
            if (object instanceof NativeJavaObject) {
                object = ((NativeJavaObject)object).unwrap();
            }
            return (EventTarget)object;
        }

        public short getEventPhase() {
            Object object = this.scriptable.get("eventPhase", this.scriptable);
            Integer n = (Integer)Context.jsToJava((Object)object, (Class)(class$java$lang$Integer == null ? (class$java$lang$Integer = EventTargetWrapper.class$("java.lang.Integer")) : class$java$lang$Integer));
            return (short)n.intValue();
        }

        public boolean getBubbles() {
            Object object = this.scriptable.get("bubbles", this.scriptable);
            Boolean bl = (Boolean)Context.jsToJava((Object)object, (Class)(class$java$lang$Boolean == null ? (class$java$lang$Boolean = EventTargetWrapper.class$("java.lang.Boolean")) : class$java$lang$Boolean));
            return bl;
        }

        public boolean getCancelable() {
            Object object = this.scriptable.get("cancelable", this.scriptable);
            Boolean bl = (Boolean)Context.jsToJava((Object)object, (Class)(class$java$lang$Boolean == null ? (class$java$lang$Boolean = EventTargetWrapper.class$("java.lang.Boolean")) : class$java$lang$Boolean));
            return bl;
        }

        public long getTimeStamp() {
            Object object = this.scriptable.get("timeStamp", this.scriptable);
            Double d = (Double)Context.jsToJava((Object)object, (Class)(class$java$lang$Double == null ? (class$java$lang$Double = EventTargetWrapper.class$("java.lang.Double")) : class$java$lang$Double));
            return (long)d.doubleValue();
        }

        public void stopPropagation() {
            this.call("stopPropagation");
        }

        public void preventDefault() {
            this.call("preventDefault");
        }

        public void initEvent(String string, boolean bl, boolean bl2) {
            this.call("initEvent", new Object[]{string, new Boolean(bl), new Boolean(bl2)});
        }

        public String getNamespaceURI() {
            return (String)Context.jsToJava((Object)this.scriptable.get("namespaceURI", this.scriptable), (Class)(class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String));
        }

        public boolean isCustom() {
            Boolean bl = (Boolean)Context.jsToJava((Object)this.call("isCustom"), (Class)(class$java$lang$Boolean == null ? (class$java$lang$Boolean = EventTargetWrapper.class$("java.lang.Boolean")) : class$java$lang$Boolean));
            return bl;
        }

        public void stopImmediatePropagation() {
            this.call("stopImmediatePropagation");
        }

        public boolean isDefaultPrevented() {
            Boolean bl = (Boolean)Context.jsToJava((Object)this.call("isDefaultPrevented"), (Class)(class$java$lang$Boolean == null ? (class$java$lang$Boolean = EventTargetWrapper.class$("java.lang.Boolean")) : class$java$lang$Boolean));
            return bl;
        }

        public void initEventNS(String string, String string2, boolean bl, boolean bl2) {
            this.call("initEventNS", new Object[]{string, string2, new Boolean(bl), new Boolean(bl2)});
        }

        public void setDispatchState(EventTarget eventTarget, short s) {
            this.call("setDispatchState", new Object[]{eventTarget, new Double(s)});
        }

        public boolean isPropagationStopped() {
            Boolean bl = (Boolean)Context.jsToJava((Object)this.call("isPropagationStopped"), (Class)(class$java$lang$Boolean == null ? (class$java$lang$Boolean = EventTargetWrapper.class$("java.lang.Boolean")) : class$java$lang$Boolean));
            return bl;
        }

        public boolean isImmediatePropagationStopped() {
            Boolean bl = (Boolean)Context.jsToJava((Object)this.call("isImmediatePropagationStopped"), (Class)(class$java$lang$Boolean == null ? (class$java$lang$Boolean = EventTargetWrapper.class$("java.lang.Boolean")) : class$java$lang$Boolean));
            return bl;
        }

        public void resumePropagation() {
            this.call("resumePropagation");
        }

        public CustomEvent retarget(EventTarget eventTarget) {
            Object object = this.call("cloneEventObject", new Object[]{eventTarget});
            if (object instanceof ScriptableObject) {
                ScriptableObject scriptableObject = (ScriptableObject)object;
                scriptableObject.put("originalEvent", (Scriptable)scriptableObject, (Object)this.scriptable);
                scriptableObject.put("target", (Scriptable)scriptableObject, (Object)Context.toObject((Object)eventTarget, (Scriptable)this.scriptable));
                scriptableObject.put("type", (Scriptable)scriptableObject, this.scriptable.get("type", this.scriptable));
                scriptableObject.put("currentTarget", (Scriptable)scriptableObject, this.scriptable.get("currentTarget", this.scriptable));
                scriptableObject.put("eventPhase", (Scriptable)scriptableObject, this.scriptable.get("eventPhase", this.scriptable));
                scriptableObject.put("bubbles", (Scriptable)scriptableObject, this.scriptable.get("bubbles", this.scriptable));
                scriptableObject.put("cancelable", (Scriptable)scriptableObject, this.scriptable.get("cancelable", this.scriptable));
                scriptableObject.put("timeStamp", (Scriptable)scriptableObject, this.scriptable.get("timeStamp", this.scriptable));
                scriptableObject.put("namespaceURI", (Scriptable)scriptableObject, this.scriptable.get("namespaceURI", this.scriptable));
                ObjectCustomEvent objectCustomEvent = new ObjectCustomEvent((Scriptable)((NativeObject)object), this.interpreter, this.eventMap);
                this.eventMap.put(object, new SoftReference<ObjectCustomEvent>(objectCustomEvent));
                return objectCustomEvent;
            }
            return null;
        }

        public Event getOriginalEvent() {
            Object object = this.scriptable.get("target", this.scriptable);
            if (object instanceof NativeJavaObject) {
                object = ((NativeJavaObject)object).unwrap();
            }
            return (Event)object;
        }
    }

    static class HandleEventListener
    implements EventListener {
        public static final String HANDLE_EVENT = "handleEvent";
        public Scriptable scriptable;
        public Object[] array = new Object[1];
        public RhinoInterpreter interpreter;

        HandleEventListener(Scriptable scriptable, RhinoInterpreter rhinoInterpreter) {
            this.scriptable = scriptable;
            this.interpreter = rhinoInterpreter;
        }

        public void handleEvent(Event event) {
            this.array[0] = event instanceof ScriptEventWrapper ? ((ScriptEventWrapper)((Object)event)).getEventObject() : event;
            ContextAction contextAction = new ContextAction(this){
                private final /* synthetic */ HandleEventListener this$0;
                {
                    this.this$0 = handleEventListener;
                }

                public Object run(Context context) {
                    ScriptableObject.callMethod((Scriptable)this.this$0.scriptable, (String)"handleEvent", (Object[])this.this$0.array);
                    return null;
                }
            };
            this.interpreter.call(contextAction);
        }
    }

    static class FunctionEventListener
    implements EventListener {
        protected Function function;
        protected RhinoInterpreter interpreter;

        FunctionEventListener(Function function, RhinoInterpreter rhinoInterpreter) {
            this.function = function;
            this.interpreter = rhinoInterpreter;
        }

        public void handleEvent(Event event) {
            Object object = event instanceof ScriptEventWrapper ? ((ScriptEventWrapper)((Object)event)).getEventObject() : event;
            this.interpreter.callHandler(this.function, object);
        }
    }
}

