/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.geom;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.apache.batik.ext.awt.geom.Polygon2D;

public class Polyline2D
implements Shape,
Cloneable,
Serializable {
    private static final float ASSUME_ZERO = 0.001f;
    public int npoints;
    public float[] xpoints;
    public float[] ypoints;
    protected Rectangle2D bounds;
    private GeneralPath path;
    private GeneralPath closedPath;

    public Polyline2D() {
        this.xpoints = new float[4];
        this.ypoints = new float[4];
    }

    public Polyline2D(float[] fArray, float[] fArray2, int n) {
        if (n > fArray.length || n > fArray2.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        this.npoints = n;
        this.xpoints = new float[n];
        this.ypoints = new float[n];
        System.arraycopy(fArray, 0, this.xpoints, 0, n);
        System.arraycopy(fArray2, 0, this.ypoints, 0, n);
        this.calculatePath();
    }

    public Polyline2D(int[] nArray, int[] nArray2, int n) {
        if (n > nArray.length || n > nArray2.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        this.npoints = n;
        this.xpoints = new float[n];
        this.ypoints = new float[n];
        for (int i = 0; i < n; ++i) {
            this.xpoints[i] = nArray[i];
            this.ypoints[i] = nArray2[i];
        }
        this.calculatePath();
    }

    public Polyline2D(Line2D line2D) {
        this.npoints = 2;
        this.xpoints = new float[2];
        this.ypoints = new float[2];
        this.xpoints[0] = (float)line2D.getX1();
        this.xpoints[1] = (float)line2D.getX2();
        this.ypoints[0] = (float)line2D.getY1();
        this.ypoints[1] = (float)line2D.getY2();
        this.calculatePath();
    }

    public void reset() {
        this.npoints = 0;
        this.bounds = null;
        this.path = new GeneralPath();
        this.closedPath = null;
    }

    public Object clone() {
        Polyline2D polyline2D = new Polyline2D();
        for (int i = 0; i < this.npoints; ++i) {
            polyline2D.addPoint(this.xpoints[i], this.ypoints[i]);
        }
        return polyline2D;
    }

    private void calculatePath() {
        this.path = new GeneralPath();
        this.path.moveTo(this.xpoints[0], this.ypoints[0]);
        for (int i = 1; i < this.npoints; ++i) {
            this.path.lineTo(this.xpoints[i], this.ypoints[i]);
        }
        this.bounds = this.path.getBounds2D();
        this.closedPath = null;
    }

    private void updatePath(float f, float f2) {
        this.closedPath = null;
        if (this.path == null) {
            this.path = new GeneralPath(0);
            this.path.moveTo(f, f2);
            this.bounds = new Rectangle2D.Float(f, f2, 0.0f, 0.0f);
        } else {
            this.path.lineTo(f, f2);
            float f3 = (float)this.bounds.getMaxX();
            float f4 = (float)this.bounds.getMaxY();
            float f5 = (float)this.bounds.getMinX();
            float f6 = (float)this.bounds.getMinY();
            if (f < f5) {
                f5 = f;
            } else if (f > f3) {
                f3 = f;
            }
            if (f2 < f6) {
                f6 = f2;
            } else if (f2 > f4) {
                f4 = f2;
            }
            this.bounds = new Rectangle2D.Float(f5, f6, f3 - f5, f4 - f6);
        }
    }

    public void addPoint(Point2D point2D) {
        this.addPoint((float)point2D.getX(), (float)point2D.getY());
    }

    public void addPoint(float f, float f2) {
        if (this.npoints == this.xpoints.length) {
            float[] fArray = new float[this.npoints * 2];
            System.arraycopy(this.xpoints, 0, fArray, 0, this.npoints);
            this.xpoints = fArray;
            fArray = new float[this.npoints * 2];
            System.arraycopy(this.ypoints, 0, fArray, 0, this.npoints);
            this.ypoints = fArray;
        }
        this.xpoints[this.npoints] = f;
        this.ypoints[this.npoints] = f2;
        ++this.npoints;
        this.updatePath(f, f2);
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            return null;
        }
        return this.bounds.getBounds();
    }

    private void updateComputingPath() {
        if (this.npoints >= 1 && this.closedPath == null) {
            this.closedPath = (GeneralPath)this.path.clone();
            this.closedPath.closePath();
        }
    }

    public boolean contains(Point point) {
        return false;
    }

    public boolean contains(double d, double d2) {
        return false;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    public boolean contains(Point2D point2D) {
        return false;
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        if (this.npoints <= 0 || !this.bounds.intersects(d, d2, d3, d4)) {
            return false;
        }
        this.updateComputingPath();
        return this.closedPath.intersects(d, d2, d3, d4);
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        return false;
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return false;
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        if (this.path == null) {
            return null;
        }
        return this.path.getPathIterator(affineTransform);
    }

    public Polygon2D getPolygon2D() {
        Polygon2D polygon2D = new Polygon2D();
        for (int i = 0; i < this.npoints - 1; ++i) {
            polygon2D.addPoint(this.xpoints[i], this.ypoints[i]);
        }
        Point2D.Double double_ = new Point2D.Double(this.xpoints[0], this.ypoints[0]);
        Point2D.Double double_2 = new Point2D.Double(this.xpoints[this.npoints - 1], this.ypoints[this.npoints - 1]);
        if (double_.distance(double_2) > (double)0.001f) {
            polygon2D.addPoint(this.xpoints[this.npoints - 1], this.ypoints[this.npoints - 1]);
        }
        return polygon2D;
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this.path.getPathIterator(affineTransform);
    }
}

