/***************************************************************************
 *            baobab.h
 *
 *  Tue Jul  5 10:36:52 2005
 *  Copyright  2005  Fabio Marzocca
 *  Email
 ****************************************************************************/
#ifndef __BAOBAB_H__
#define __BAOBAB_H__

#include "utilities.h"

	#define PIX_DIR (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps")
	#define SCRIPTS_DIR (PACKAGE_DATA_DIR "/" PACKAGE "/scripts")
	
//	#define PIX_DIR "pixmaps"
//	#define SCRIPTS_DIR "scripts"

#define VIEW_TREE 0
#define VIEW_SEARCH 1

	#define PROPS_SCAN_KEY "/apps/baobab/properties/noscan"
	#define PROPS_ENABLE_HOME_MONITOR "/apps/baobab/properties/enable_home_monitor"
	#define BAOBAB_KEY "/apps/baobab"

//Globals
struct {
  	GtkWidget *window;
  	GtkWidget * tree_view, * tree_search;
	GtkTreeStore * model;
	GtkListStore* model_search;
	GtkTreeStore * search_model;
	gboolean STOP_SCANNING;
	GdkPixbuf * green_bar,*yellow_bar,*red_bar;
	gboolean CONTENTS_CHANGED_DELAYED;
	GSList * bbExcludedDirs;
	gboolean bbEnableHomeMonitor;
	gchar* label_scan;
	gchar* label_search;
	GString* last_scan_command;
	gint number_found_files;
 	guint64 size_found_files;
	gboolean show_allocated;
} baobab;
// 
	struct _fs {
		guint64 total;
		guint64 used;
		guint64 avail;
	} g_fs;
	
	struct chan_data {
		guint64 size;
		guint64 alloc_size;
		guint depth;
		gint elements;
		guint64 tempHLsize;
		gchar *dir;
	};
	
	struct BaobabSearchRet {
		gchar * fullpath;
		guint64 size;
		guint64 alloc_size;
		time_t lastacc;
		uid_t owner;
	};
	
	//Advanced search options enums
	enum {
		NONE=1,
		LAST_WEEK=2,
		LAST_MONTH=3,
		SIZE_SMALL=2,
		SIZE_MEDIUM=3
	};
	
	struct BaobabSearchOpt {
		GString* filename;
		gboolean exact;
		gboolean search_whole;
		GString * dir;
		gint mod_date;
		gint size_limit;
		gboolean dont_recurse_dir;
	} bbSearchOpt;
	

	void start_proc_on_dir (gchar *);
	void fill_model (gchar* );
	void start_search (gchar*,gchar*);
	void fill_search_model(struct BaobabSearchRet *);
	void first_row(void);
	gint list_find  (gconstpointer a, gconstpointer b);
	
#endif
