<?php

require_once('HttpUtil.php');
		
class Editor {

var $footer;
var $header;
var $base;
var $prop;

function Editor(&$prop) {
	$this->prop = &$prop;
	$this->base = dirname(__FILE__) . '/Editor';
	$this->template = $this->base . '/template.php';
}

function handleRequest(&$page, $edit_action) {
	$this->page = &$page;
	if ($this->isRepeat()) {
		$this->error('That action as already been performed');
	}
	else {
		$action = $edit_action;
		if ($page->path == '/.clipboard' || $page->path == '/.trash')
			$action = 'info';

		while(true) {
			$handler = 'do_' . $action;
			if (method_exists($this,$handler)) {
				$action = $this->$handler($page);
				if ($action == 'edit')
					continue;
				else
					return $action;
			}
			else {
				die("editor action '$action' unknown");
				return '';
			}
		}
	}
	return '';
}

function do_edit(&$page) {
	$draft = true;
	$page->setVersion('draft');	
	$this->text = & $page->get('content');
	if ($this->text == '') {
		$page->setVersion('');
		$this->text = & $page->get('content');
		$draft = false;
	}
	$this->text = htmlspecialchars($this->text);
	$this->display('edit', array('draft'=>$draft));
}

/*
 * new edit: this is a quick 'new page and edit' mode
 * for adding a new page and content at the same time.
 * it is useful to display when a page is not found.
 */
function do_newedit(&$page) {
	$newpage = $page->ps->getPage(get('path'));
	$GLOBALS['edit-tabs'] = array(_("Create")=>array('newedit',1));
	$GLOBALS['newpage'] = &$newpage;
	
	$this->display('newedit');
}

/*
 creates a new page and sets the content in one swoop.
 */
function do_create(&$page) {
	$name = getraw('name');
	$newpage = &$page->ps->newChild($page,$name);
	if (!$newpage->ok) {
		$this->error($newpage->error());
		return;
	}
	
	foreach(array('title','subject','description','keywords') as $prop) {
		$newpage->set($prop,get($prop));
	}
	$data = &getraw('data');
	$newpage->setContent($data);
	$newpage->commit();

	$page->set('dir',true);
	$page->commit();

	if ($newpage->ok) {
		http::redirect($newpage->absolutepath);
		return;
	}
	if (!$newpage->ok) {
		$this->error($page->error());
		return;
	}
}

function do_guide(&$page) {
	include($this->template('guide'));
}

function do_preview(&$page) {
	$_SESSION[$page->path . '#selectionstart'] = get('selectionstart',0);
	$_SESSION[$page->path . '#selectionend']   = get('selectionend',0);
	$_SESSION[$page->path . '#scrolltop']      = get('scrolltop',0);

	$data = &getraw('data');
	$page->setVersion('draft');
	$page->setContent($data);
	$page->commit();
	return 'viewdraft';
}

function do_publish(&$page) {
	$_SESSION[$page->path . '#selectionstart'] = get('selectionstart',0);
	$_SESSION[$page->path . '#selectionend']   = get('selectionend',0);
	$_SESSION[$page->path . '#scrolltop']      = get('scrolltop',0);

	# todo:
	# - remove draft in a better way.
	# - create a new version out of the previous content

	$page->setVersion('draft');
	$emptystr = '';
	$page->setContent($emptystr);
	$page->commit();

	$page->setVersion('');
	$data = &getraw('data');
	$page->setContent($data);
	$page->commit();
	return 'view';
}

function do_save(&$page) {
	$data = &getraw('data');
	$page->setVersion('draft');
	$page->setContent($data);
	$page->commit();
	return 'edit';
}
 
function do_cancel(&$page) {
	$page->setVersion('draft');
	$emptystr = '';
	$page->setContent($emptystr);
	$page->commit();
	
	$page->setVersion('');
	return 'view';
}

function do_props(&$page) {
	$this->display('props');
	return '';
}

function do_perms(&$page) {
	$this->display('perms');
	return '';
}

function do_info(&$page) {
	$name = '';
	if (get('clip'))
		return $this->do_clip($page);
		
	$move = get('move');	
	$save = get('save');
	$attachcmd = get('attachcmd');
	
	if ($move) {
		$child = $page->child(get('child'));
		$order = $child->get('order');
		if ($move == 'up')
			$order--;
		if ($move == 'down')
			$order++;
		$child->set('order',$order);
	}
	elseif($save) {
		$saveprops = array('title','subject','type','dir','description','keywords');
		
		// get a clean copy of the old values, before we start
		// setting them. why? because setting the value of one property
		// can set the value of other properties automatically. we don't
		// want a moving target.
		$oldvalues = array();
		foreach ($saveprops as $prop) {
			$oldvalues[$prop] = $page->get($prop);
		}
		
		// make title always dirty. why? otherwise we won't ever write the title unless
		// it is different from the page name, since title is populated by default with the page name.
		// this would mess up multilingual stuff. 
		if (isset($oldvalues['title'])) $oldvalues['title'] = '--force--update--of--title--';
		
		foreach ($saveprops as $prop) {
			$value = get($prop);
		    $oldvalue = $oldvalues[$prop];
			if ($value == 'false' && $oldvalue == false) {
				// do nothing
			}
			elseif ($value != $oldvalue) {
				$page->set($prop,$value);
			}
		}
		
		// compare the urlized versions: only set a new name if they different.
		$name = urlize($page->name);
		$newname = urlize(getraw('name'));
		if ($name != $newname) {
			$page->set('name',getraw('name'));
			// if title is the same as name, then change the title too.
			if ($name == urlize($page->get('title'))) 
				$page->set('title',deurlize($newname));
		}
		
		$order = $page->get('order');
		$page->commit();
		$page->set('order',$order);

		if ($page->ok && $name != $newname) {
			http::redirect($page->absolutepath . "/?a=edit&ea=info");
			return;
		}
		if (!$page->ok) {
			$this->error($page->error());
		}
	}
	elseif($attachcmd == 'upload') {
		$page->attach($_FILES['userfile']);
		if (!$page->ok) {
			$this->error($page->error());
		}
	}
	elseif($attachcmd == 'delete') {
		$checked = get('checked');
		if ($checked) {
			foreach($checked as $filename => $on) {
				$page->removeAttachment($filename);
			}
			if (!$page->ok)	$this->error($page->error());
		}
		else {
			$this->error("To delete an attachment, at least one file must be checked.");
		}
	}

	$this->display('info');
	return '';
}

// page clipboard functions
function do_clip(&$page) {
	$action = get('clip');
	$checked = get('checked');
	$quick = get('quick');
	$where = get('where');
	
	$ps = &$page->ps; // page store
	
	$ps->makepath('.trash');
	$ps->makepath('.clipboard');
	
	if ($action == 'paste') {
		if ($where == '' || $where == 'into') {
			$p = &$page;
			$order = 0;
		}
		elseif ($where == 'before') {
			$p = & $page->parent();
			$order = $page->get('order');
		}
		elseif ($where == 'after') {
			$p = & $page->parent();
			$order = $page->get('order') + 1;
		}
		
		$clipboard = $ps->getPage('/.clipboard');
		$children = $clipboard->children();
		if (count($children)) {
			$ok = true;
			foreach($children as $child) {
				$child->setParent($p->path);
				if (!$child->ok) {
					$this->error($child->error());
					$ok = false;
					break;
				}
				$child->set('order',$order);
			}
			if ($ok) {
				$p->set('dir',true);
				$p->commit();
			}
		}
		else {
			$this->error("To paste a page, at least one page must be in the clipboard.");
		}
		
		if ($ok && $where != '' && count($children) == 1) {
			http::redirect("$child->absolutepath/?a=edit&ea=info");
			return '';
		}
	}
	elseif ($action == 'cut') {
		if ($checked) {
			foreach($checked as $childname => $on) {
				$child = $page->child($childname);
				$child->move("/.clipboard/" . basename($child->path));
				if (!$child->ok) $this->error($child->error());
			}
		}
		elseif($quick) {
			$parent = & $page->parent();
			$page->move("/.clipboard/" . basename($page->path));
			if (!$page->ok)
				$this->error($page->error());
			else {
				http::redirect("$parent->absolutepath/?a=edit&ea=info");
				return '';
			}
		}
		else {
			$this->error("To cut a page, at least one page must be checked.");
		}
	}
	elseif ($action == 'copy') {
		if ($checked) {
			foreach($checked as $childname => $on) {
				$child = $page->child($childname);
				$child->duplicate("/.clipboard/" . basename($child->path));
				if (!$child->ok) $this->error($child->error());
			}
		}
		elseif($quick) {
			$page->duplicate("/.clipboard/" . basename($page->path));
			if (!$page->ok) $this->error($page->error());
		}
		else {
			$this->error("To copy a page, at least one page must be checked.");
		}
	}
	elseif ($action == 'delete') {
		if ($checked) {
			foreach($checked as $childname => $on) {
				$child = $page->child($childname);
				$child->move("/.trash/" . basename($child->path));
				if (!$child->ok)
					$this->error($child->error());
			}
			if ($page->childCount() == 0) {
				$page->set('dir',false);
				$page->commit();
			}
		}
		elseif($quick) {
			$parent = $page->parent();
			$page->move("/.trash/" . basename($page->path));
			if (!$page->ok) $this->error($page->error());
			if ($parent->childCount() == 0) {
				$parent->set('dir',false);
				$parent->commit();
			}
			http::redirect("$parent->absolutepath/?a=edit&ea=info");
			return '';
		}
		else
			$this->error("To delete a page, at least one page must be checked.");
	}
	elseif ($action == 'new') {
		if ($where == '' || $where == 'into') {
			$p = &$page;
			$order = 0;
		}
		elseif ($where == 'before') {
			$p = & $page->parent();
			$order = $page->get('order');
		}
		elseif ($where == 'after') {
			$p = & $page->parent();
			$order = $page->get('order') + 1;
		}
			
		for ($i=0; true; $i++) {
			$newpage = $p->child("untitled" . $i);
			if ($newpage->fnf) break;
		}	
		$newpage = &$p->ps->newChild($p,"untitled" . $i);
		if (!$newpage->ok) {
			$this->error($newpage->error());
			return;
		}
		else {
			$newpage->set('mtime',time());
			$newpage->set('order',$order);
			$newpage->commit();
			$p->set('dir',true);
			$p->commit();
		}
		
		if ($quick) {
			http::redirect("$newpage->absolutepath?a=edit&ea=info");
			return '';
		}
	}
	elseif ($action == 'destroyall') {
		$children = $page->children();
		foreach($children as $child) {
			$child->destroy();
			if (!$child->ok)
				$this->error($child->error());
		}
	}

	$this->display('info');
	return '';
}

function do_versions(&$page) {
	$this->display('versions');
	return '';
}

function do_view(&$page) {
	return 'view';
}

function do_history(&$page) {
	$this->display('history');
	return '';
}

function display($template,$args='') {
	// set up global vars to be used by templates
	global $editor, $page, $ps, $nav, $prop, $root;
	if (is_array($args)) extract($args, EXTR_SKIP);
	$e = &$this;
	$GLOBALS['decoratorurl'] =  $this->prop->getGlobal('liburl') . '/decorators/editor';
	$action = $page->absolutepath . '/';

	// these headers make it so that when you hit the back button, you will
	// get whatever text you had open in the textarea when you were last on the page.
	header("Expires: -1");
	header("Cache-Control: private, s-maxage=0, max-age=0, must-revalidate");

			
	// render page
	require_once('decorators/common.php');
	ob_start();
		include($this->template($template));
		$content = &ob_get_contents();
	ob_end_clean();
	$errors = errors();
	include( dirname(__FILE__) . "/decorators/editor/template.php" );
}

function error($msg) {
	trigger_error($msg);
}

function template($name) {
	return dirname(__FILE__) . "/editor/$name.php";
}

function isRepeat() {
	$serial = get('serial',-1);
	return false;
}

} // end class
return;
?>
